/*
** File: v5clksynth.h  
** Project: ADB3 core driver
** Purpose: Definitions for Virtex-5 PLL clock synthesizer
**
** (C) Copyright Alpha Data 2011
*/

#ifndef _ADATA_CORE_V5CLKSYNTH_H
#define _ADATA_CORE_V5CLKSYNTH_H

#include <df.h>
#include "coreif.h"

struct _Adb3CoreDeviceContext;
struct _V5ClkSynthProgramRequest;
typedef struct _V5ClkSynthProgramRequest V5ClkSynthProgramRequest;
struct _V5ClkSynthProgramRequestSync;
typedef struct _V5ClkSynthProgramRequestSync V5ClkSynthProgramRequestSync;

typedef struct _V5ClkSynthDeviceContext {
  DfTimer timer;           /* Timer for checking that clock synthesizer programming was successful */
  struct { /* Used to save & restore state when powering down & up */
    CoreClockWord last;
    boolean_t bLastValid;
  } save;
} V5ClkSynthDeviceContext;

typedef enum _V5ClkSynthClockWordStatus {
  V5ClkSynthClockWordStatusSuccess = 0,
  V5ClkSynthClockWordStatusOutOfRange = 1,
  V5ClkSynthClockWordStatusGeneralFailure = 2
} V5ClkSynthClockWordStatus;

typedef enum _V5ClkSynthProgramStatus {
  V5ClkSynthProgramStatusSuccess = 0,
  V5ClkSynthProgramStatusHardwareError = 1,
  V5ClkSynthProgramStatusGeneralFailure = 2
} V5ClkSynthProgramStatus;

typedef void V5ClkSynthProgramCallback(struct _Adb3CoreDeviceContext* pDevCtx, V5ClkSynthDeviceContext* pV5ClkSynthCtx, V5ClkSynthProgramRequest* pRequest, V5ClkSynthProgramStatus status);

struct _V5ClkSynthProgramRequest {
  V5ClkSynthDeviceContext* pV5ClkSynthCtx;
  V5ClkSynthProgramCallback* pCallback;
  CoreClockWord clockWord;
};

struct _V5ClkSynthProgramRequestSync {
  V5ClkSynthProgramRequest request;
  DfEvent ev;
  V5ClkSynthProgramStatus status;
};

#endif
