/*
** File: ucd90120buf.h  
** Project: ADB3 core driver
** Purpose: Exports functions for accessing buffered rail readings
**          of the UCD90120 system monitor, in models that use it.
**
** (C) Copyright Alpha Data 2014
*/

#ifndef _ADATA_CORE_UCD90120BUF_H
#define _ADATA_CORE_UCD90120BUF_H

#include <df.h>
#include "coreif.h"

#define UCD90120SENSORTYPE_VOLTAGE (0)
#define UCD90120SENSORTYPE_CURRENT (1)
#define UCD90120SENSORTYPE_TEMP    (2)

extern boolean_t
ucd90120BufReadSensor(
  void* pUcd90120Buf,          /* Kernel-space pointer to UCD90120_BUF region in model-specific Bridge registers */
  DfMemoryHandle hUcd90120Buf, /* Handle corresponding to pUcd90120Buf as per dfPciMem* functions */
  unsigned int railIndex,      /* UCD90120 rail index, 0-based (0 => rail 1, 1 => rail 2 etc.) */
  unsigned int type,           /* What to extract from raw reading: voltage, current or temperature */
  CoreSensorValue* pReading);

#endif
