/*
** File: serializer.c  
** Project: ADB3 core driver
** Purpose: Implements serialization mechanism
**
** (C) Copyright Alpha Data 2011
*/

#include <df.h>

#include "serializer.h"

void
serializerQueueInit(
  SerializerQueue* pQueue)
{
  dfSpinLockInit(&pQueue->lock);
  dfListInit(&pQueue->requests);
}

void
_serializerSyncCallback(
  SerializerQueue* pQueue,
  SerializerRequest* pRequest,
  void* pContext)
{
  SerializerRequestSync* pSyncRequest = DF_CONTAINER_OF(pRequest, SerializerRequestSync, request);
  dfEventSignal(pSyncRequest->pEvent);
}

boolean_t
serializerCancel(
  SerializerQueue* pQueue,
  SerializerRequest* pRequest)
{
  DfSpinLockFlags f;
  DfListNode* pHead;

  f = dfSpinLockGet(&pQueue->lock);
  pHead = dfListGetHead(&pQueue->requests);
  if (pHead == &pRequest->node) {
    /* Callback is running or has already run */
    dfSpinLockPut(&pQueue->lock, f);
    return FALSE;
  } else {
    /* Successfully cancelled */
    dfListRemove(&pRequest->node);
    dfSpinLockPut(&pQueue->lock, f);
    return TRUE;
  }
}
