/*
** File: prodtest.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for IOCTL handlers that support
**          production testing.
**
** (C) Copyright Alpha Data 2011, 2015
*/

#if !defined(ADATA_CORE_PRODTEST_H)
#define ADATA_CORE_PRODTEST_H

#include <df.h>
#include "device.h"
#include <adb3/types.h>

extern DfIoStatus
ioctlGetProdTestInfo(
	Adb3CoreDeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int outSize);

extern DfIoStatus
ioctlGetUniqueId(
	Adb3CoreDeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int outSize);

extern DfIoStatus
ioctlServiceIrq(
	Adb3CoreDeviceContext* pDevCtx,
  Adb3CoreClientContext* pClCtx,
  void* pBuffer,
  unsigned int outSize);

extern DfIoStatus
ioctlAbortIprog(
	Adb3CoreDeviceContext* pDevCtx,
  Adb3CoreClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

extern DfIoStatus
ioctlScheduleIprog(
	Adb3CoreDeviceContext* pDevCtx,
  Adb3CoreClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

extern DfIoStatus
ioctlStatusIprog(
	Adb3CoreDeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlCommandAvr2(
	Adb3CoreDeviceContext* pDevCtx,
  Adb3CoreClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlCommandAvr2Thunk(
	Adb3CoreDeviceContext* pDevCtx,
  Adb3CoreClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlGetAvr2Status(
	Adb3CoreDeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int outSize);

#endif
