/*
** File: main.h  
** Project: ADB3 core driver
** Purpose: Declare top-level functions of driver
**
** (C) Copyright Alpha Data 2009-2010
*/

#ifndef _ADATA_CORE_MAIN_H
#define _ADATA_CORE_MAIN_H

#include <df.h>

#include "device.h"

extern boolean_t
adb3CoreOnStart(
  DfDeviceObject* pDevObj,
  Adb3CoreDeviceContext* pDevCtx,
  DfBusResources* pRawRes,
  DfBusResources* pTranslatedRes);

extern void
adb3CoreOnStop(
  DfDeviceObject* pDevObj,
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bCanTouchHardware);

extern boolean_t
adb3CoreOnAdd(
  DfDeviceObject* pDevObj,
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreOnRemove(
  DfDeviceObject* pDevObj,
  Adb3CoreDeviceContext* pDevCtx);

extern boolean_t
adb3CoreOnPowerQuery(
	DfDeviceObject* pDevObj,
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int currentState,
  unsigned int requestedState,
  boolean_t bIsShutdown);

extern void
adb3CoreOnPowerSet(
	DfDeviceObject* pDevObj,
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int currentState,
  unsigned int newState,
  boolean_t bIsShutdown);

extern boolean_t
adb3CoreDriverEntry(
  DfDriverObject* pDrvObj);

extern void
adb3CoreDriverExit(
  DfDriverObject* pDrvObj);

#endif
