/*
** File: ics8430_61_common.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the ICS8430-61 clock generator.
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_ICS8430_61_COMMON_H
#define _ADATA_CORE_ICS8430_61_COMMON_H

#include <df.h>
#include "device.h"
#include "ics8430_61.h"

extern Ics8430_61ClockWordStatus
clockWordIcs8430_61(
  uint32_t flags,
  uint32_t refFrequency,
  uint64_t frequencyReq,
  uint64_t frequencyMin,
  uint64_t frequencyMax,
  CoreClockWord* pClockWord);

extern boolean_t
ics8430_61Init(
  Adb3CoreDeviceContext* pDevCtx,
  Ics8430_61DeviceContext* pIcs8430_61Ctx,
  uint32_t refFrequency,
  uint32_t* pReg,
  DfMemoryHandle hReg,
  uint32_t* pFOut);

extern void
ics8430_61Uninit(
  Adb3CoreDeviceContext* pDevCtx,
  Ics8430_61DeviceContext* pIcs8430_61Ctx);

extern Ics8430_61ProgramStatus
ics8430_61Program(
  Adb3CoreDeviceContext* pDevCtx,
  Ics8430_61DeviceContext* pIcs8430_61Ctx,
  Ics8430_61ProgramRequest* pRequest,
  const CoreClockWord* pClockWord,
  Ics8430_61ProgramCallback* pCallback);

/* Must be called in thread context */
extern Ics8430_61ProgramStatus
ics8430_61ProgramSync(
  Adb3CoreDeviceContext* pDevCtx,
  Ics8430_61DeviceContext* pIcs8430_61Ctx,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
ics8430_61SaveState(
  Adb3CoreDeviceContext* pDevCtx,
  Ics8430_61DeviceContext* pIcs8430_61Ctx);

/* Must be called in thread context */
extern Ics8430_61ProgramStatus
ics8430_61RestoreState(
  Adb3CoreDeviceContext* pDevCtx,
  Ics8430_61DeviceContext* pIcs8430_61Ctx);

/* Convenience functions */

extern ClockProgramStatus
ics8430_61MapProgramStatus(
  Ics8430_61ProgramStatus status);

extern ClockWordStatus
ics8430_61MapClockWordStatus(
  Ics8430_61ClockWordStatus status);

#endif
