/*
** File: ics843034_01_common.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the ICS843034_01 clock generator.
**
** (C) Copyright Alpha Data 2011
*/

#ifndef _ADATA_CORE_ICS843034_01_COMMON_H
#define _ADATA_CORE_ICS843034_01_COMMON_H

#include <df.h>
#include "device.h"
#include "ics843034_01.h"

extern Ics843034_01ClockWordStatus
clockWordIcs843034_01(
  uint32_t flags,
	uint32_t xtalFrequency1,
	uint32_t xtalFrequency2,
	uint64_t frequencyReq,
	uint64_t frequencyMin,
	uint64_t frequencyMax,
  CoreClockWord* pClockWord);

extern boolean_t
ics843034_01Init(
  Adb3CoreDeviceContext* pDevCtx,
  Ics843034_01DeviceContext* pIcs843034_01Ctx,
  unsigned int refClk1,
  unsigned int refClk2,
  uint32_t* pReg,
  DfMemoryHandle hReg,
  uint32_t* pFOut);

extern void
ics843034_01Uninit(
  Adb3CoreDeviceContext* pDevCtx,
  Ics843034_01DeviceContext* pIcs843034_01Ctx);

extern Ics843034_01ProgramStatus
ics843034_01Program(
  Adb3CoreDeviceContext* pDevCtx,
  Ics843034_01DeviceContext* pIcs843034_01Ctx,
  Ics843034_01ProgramRequest* pRequest,
  const CoreClockWord* pClockWord,
  Ics843034_01ProgramCallback* pCallback);

/* Must be called in thread context */
extern Ics843034_01ProgramStatus
ics843034_01ProgramSync(
  Adb3CoreDeviceContext* pDevCtx,
  Ics843034_01DeviceContext* pIcs843034_01Ctx,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
ics843034_01SaveState(
  Adb3CoreDeviceContext* pDevCtx,
  Ics843034_01DeviceContext* pIcs843034_01Ctx);

/* Must be called in thread context */
extern Ics843034_01ProgramStatus
ics843034_01RestoreState(
  Adb3CoreDeviceContext* pDevCtx,
  Ics843034_01DeviceContext* pIcs843034_01Ctx);

/* Convenience functions */

extern ClockProgramStatus
ics843034_01MapProgramStatus(
  Ics843034_01ProgramStatus status);

extern ClockWordStatus
ics843034_01MapClockWordStatus(
  Ics843034_01ClockWordStatus status);

#endif
