/*
** File: ics307_common.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the ICS307 clock generator.
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_ICS307_COMMON_H
#define _ADATA_CORE_ICS307_COMMON_H

#include <df.h>
#include "device.h"
#include "ics307.h"

extern Ics307ClockWordStatus
clockWordIcs307(
  uint32_t flags,
  uint32_t refFrequency,
  uint64_t frequencyReq,
  uint64_t frequencyMin,
  uint64_t frequencyMax,
  boolean_t bUsingClk2,
  CoreClockWord* pClockWord);

extern boolean_t
ics307Init(
  Adb3CoreDeviceContext* pDevCtx,
  Ics307DeviceContext* pIcs307Ctx,
  uint32_t refFrequency,
  Ics307InterfaceType progIf,
  boolean_t bUsingClk2,
  uint32_t* pReg,
  DfMemoryHandle hReg,
  uint32_t* pFOut);

extern void
ics307Uninit(
  Adb3CoreDeviceContext* pDevCtx,
  Ics307DeviceContext* pIcs307Ctx);

extern Ics307ProgramStatus
ics307Program(
  Adb3CoreDeviceContext* pDevCtx,
  Ics307DeviceContext* pIcs307Ctx,
  Ics307ProgramRequest* pRequest,
  const CoreClockWord* pClockWord,
  Ics307ProgramCallback* pCallback);

/* Must be called in thread context */
extern Ics307ProgramStatus
ics307ProgramSync(
  Adb3CoreDeviceContext* pDevCtx,
  Ics307DeviceContext* pIcs307Ctx,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
ics307SaveState(
  Adb3CoreDeviceContext* pDevCtx,
  Ics307DeviceContext* pIcs307Ctx);

/* Must be called in thread context */
extern Ics307ProgramStatus
ics307RestoreState(
  Adb3CoreDeviceContext* pDevCtx,
  Ics307DeviceContext* pIcs307Ctx);

/* Convenience functions */

extern ClockProgramStatus
ics307MapProgramStatus(
  Ics307ProgramStatus status);

extern ClockWordStatus
ics307MapClockWordStatus(
  Ics307ClockWordStatus status);

#endif
