/*
** File: icd2061_common.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the ICD2061 clock generator.
**
** (C) Copyright Alpha Data 2008-2011
*/

#ifndef _ADATA_CORE_ICD2061_COMMON_H
#define _ADATA_CORE_ICD2061_COMMON_H

#include "device.h"

extern Icd2061ClockWordStatus
icd2061ClockWord(
  unsigned int clockIndex,
  uint32_t flags,
	uint32_t refFrequency,
	uint64_t frequencyReq,
	uint64_t frequencyMin,
	uint64_t frequencyMax,
  CoreClockWord* pClockWord);

extern boolean_t
icd2061Init(
  Icd2061DeviceContext* pIcd2061Ctx,
  uint8_t* pReg,
  DfMemoryHandle hReg);

extern void
icd2061Uninit(
  Icd2061DeviceContext* pIcd2061Ctx);

extern Icd2061ProgramStatus
icd2061Program(
  Icd2061DeviceContext* pIcd2061Ctx,
  Icd2061ProgramRequest* pRequest,
  unsigned int index,
  const CoreClockWord* pClockWord,
  Icd2061ProgramCallback* pCallback,
  void* pContext);

/* Must be called in thread context */
extern Icd2061ProgramStatus
icd2061ProgramSync(
  Icd2061DeviceContext* pIcd2061Ctx,
  unsigned int index,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
icd2061SaveState(
  Icd2061DeviceContext* pIcd2061Ctx);

/* Must be called in thread context */
extern Icd2061ProgramStatus
icd2061RestoreState(
  Icd2061DeviceContext* pIcd2061Ctx);

/* Convenience functions */

extern ClockProgramStatus
icd2061MapProgramStatus(
  Icd2061ProgramStatus status);

extern ClockWordStatus
icd2061MapClockWordStatus(
  Icd2061ClockWordStatus status);

#endif
