/*
** File: icd2061.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the ICD2061 clock generator.
**
** (C) Copyright Alpha Data 2008-2013
*/

#ifndef _ADATA_CORE_ICD2061_H
#define _ADATA_CORE_ICD2061_H

#include <df.h>
#include "coreif.h"
#include "serializer.h"

struct _Icd2061ProgramRequest;
typedef struct _Icd2061ProgramRequest Icd2061ProgramRequest;

typedef struct _Icd2061DeviceContext {
  SerializerQueue cconSerializer;   /* Serializes ICD2061 programming operations */
  DfTimer timer;                    /* Timer for checking that ICD2061 programming was successful */
	uint8_t* pReg;                    /* Address of CCON register */
  DfMemoryHandle hReg;              /* Handle to CCON register */
  struct { /* Used to save & restore state when powering down & up */
    CoreClockWord last;
    boolean_t bLastValid;
  } save[2];
} Icd2061DeviceContext;

#define ICD2061_CLK (0x1U)
#define ICD2061_DATA (0x2U)

typedef enum _Icd2061ClockWordStatus {
  Icd2061ClockWordStatusSuccess = 0,
  Icd2061ClockWordStatusInvalidIndex = 1,
  Icd2061ClockWordStatusOutOfRange = 2,
  Icd2061ClockWordStatusGeneralFailure = 3
} Icd2061ClockWordStatus;

typedef enum _Icd2061ProgramStatus {
  Icd2061ProgramStatusSuccess = 0,
  Icd2061ProgramStatusHardwareError = 1,
  Icd2061ProgramStatusGeneralFailure = 2
} Icd2061ProgramStatus;

typedef void Icd2061ProgramCallback(Icd2061DeviceContext* pIcd2061Ctx, Icd2061ProgramRequest* pRequest, unsigned int index, Icd2061ProgramStatus status, void* pContext);

struct _Icd2061ProgramRequest {
  SerializerRequest serRequest;
  Icd2061DeviceContext* pIcd2061Ctx;
  Icd2061ProgramCallback* pCallback;
  void* pContext;
  CoreClockWord clockWord;
  unsigned int attempts;
  unsigned int index;
};

#endif
