/*
** File: icap.h  
** Project: ADB3 core driver
** Purpose: Defines ICAP context structure.
**
** (C) Copyright Alpha Data 2015
*/

#if !defined(ADATA_CORE_ICAP_H)
#define ADATA_CORE_ICAP_H

#include <df.h>
#include "admxrc6tx.h"

struct _IcapContext;
typedef struct _IcapContext IcapContext;

/* ICAP CTL register fields */
#define ICAP_REG_STAT_V_IDLE          (0x1U << 1)
#define ICAP_REG_STAT_V_COUNTINGDOWN  (0x1U << 1)
#define ICAP_REG_STAT_V_RECONFIGURING (0x1U << 2)
#define ICAP_REG_CTL_V_FIFOMODE       (0x1U << 3)
#define ICAP_REG_CTL_V_IPROG_ABORT    (0x1U << 30)
#define ICAP_REG_CTL_V_IPROG_INIT     (0x1U << 31)

typedef enum _IprogScheduleState {
  IprogScheduleStateIdle,      /* Not scheduled. */
  IprogScheduleStateFromNow, /* Scheduled; countdown is active. */
  IprogScheduleStateOnStop     /* Will be scheduled on device stop. */
} IprogScheduleState;

struct _IcapContext {
  DfSpinLock     lock;
  DfMemoryHandle hIcapRegs;
  IcapRegs*      pIcapRegs;
  uint32_t       delayCntFreqHz;
  struct {
    uint32_t ctl;
  } shadow;
  struct {
    uint32_t delayMs;
    uint32_t cfgaddrValue;
    uint32_t cfgdelayValue;
  } schedule;
  IprogScheduleState state;
};

typedef enum _IprogResult {
  IprogResultOk,           /* Successfully scheduled */
  IprogResultBadFpgaIndex, /* Target FPGA index was invalid */
  IprogResultBadDelay,     /* Delay is too long (max 1000000000 ms) */
  IprogResultBadAddress,   /* Address was invalid */
  IprogResultScheduled,    /* Could not schedule as already scheduled */
  IprogResultNotScheduled, /* Could not cancel as not scheduled */
  IprogResultUnknownError, /* Some unexpected error, e.g. something in an invalid state */
} IprogResult;

#endif
