/*
** File: i2c.h  
** Project: ADB3 core driver
** Purpose: Defines I2C-related data structures.
**
** (C) Copyright Alpha Data 2011-2013
*/

#if !defined(ADATA_CORE_I2C_H)
#define ADATA_CORE_I2C_H

#include <df.h>
#include "serializer.h"

struct _I2cContext;
typedef struct _I2cContext I2cContext;
struct _I2cRequest;
typedef struct _I2cRequest I2cRequest;

/* Hardware methods */
typedef boolean_t I2cPollMethod(I2cContext* pI2cCtx, boolean_t bWrite, uint8_t* pData, boolean_t* pbSuccess, void* pContext);
typedef void I2cStartMethod(I2cContext* pI2cCtx, uint8_t bus, uint8_t slot, uint8_t address, boolean_t bWrite, uint8_t data, void* pContext);

struct _I2cContext {
  DfMutex lock;
  SerializerQueue serializer;
  DfTimer timer;
  DfDpc dpc;
  boolean_t bDpcInitialized;
  boolean_t bInterruptDriven;
  struct {
    DfTime interval;
    DfTime expires;
  } polling;
  struct {
    DfTime interval;
    DfTime expires;
  } timeout;
  struct {
    void* pContext;
    I2cPollMethod* pI2cPoll;
    I2cStartMethod* pI2cStart;
  } method;
};

typedef enum _I2cStatus {
  I2cStatusSuccess = 0,
  I2cStatusTimeout = 1,
  I2cStatusHardwareError = 2,
  I2cStatusInvalidBus = 3,
  I2cStatusInvalidDevice = 4,
  I2cStatusInvalidAddress = 5,
  I2cStatusGeneralFailure = 6
} I2cStatus;

/* Callback, invoked on completion of an I2C operation (successfully or otherwise) */
typedef void I2cCallback(I2cContext* pI2cCtx, I2cRequest* pRequest, uint8_t data, I2cStatus status, void* pContext);

struct _I2cRequest { /* Client must not touch */
  SerializerRequest serializerRequest;
  I2cCallback* pCallback;
  void* pContext;
  uint8_t address;  /* Byte address within device */
  uint8_t device;   /* Device index on bus */
  uint8_t bus;      /* Bus index in card */
  uint8_t data;     /* Initialized by client if writing, otherwise filled in for a read by I2C core */
  boolean_t bWrite; /* TRUE for writing to an I2C device, FALSE for reading */
};

#endif
