/*
** File: flash_cfi.h  
** Project: ADB3 core driver
** Purpose: Interface to functions for dealing with CFI Flash devices.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_FLASH_CFI_H)
#define ADATA_CORE_FLASH_CFI_H

#include <df.h>
#include "cfi.h"
#include "device.h"
#include "coreif.h"

/* Clean up a 'CfiInformation' data structure */
extern void
flashCfiCleanup(
  CfiInformation* pInfo);

/* Erase a block using Intel/Sharp Extended command set (algorithm code 0x0001) */
extern CoreFlashStatus
flashCfiEraseBlock0001(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index,
  uint64_t blockAddress);

/* Erase a block using Intel Performance command set (algorithm code 0x0200) */
CoreFlashStatus
flashCfiEraseBlock0200(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int bankIndex,
  uint64_t blockAddress);

/* Attempt to identify a CFI Flash device and determine its geometry */
extern boolean_t
flashCfiIdentify(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int bankIndex,
  uint64_t chipAddress);

/* Write a previously erased block using Intel/Sharp Extended command set (algorithm code 0x0001) */
extern CoreFlashStatus
flashCfiWriteBlock0001(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index,
  uint64_t blockAddress,
  uint64_t length,
  const void* pData);

/* Write a previously erased block using Intel Performance command set (algorithm code 0x0200) */
extern CoreFlashStatus
flashCfiWriteBlock0200(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index,
  uint64_t blockAddress,
  uint64_t length,
  const void* pData);

#endif
