/*
** File: device_defs.h  
** Project: ADB3 core driver
** Purpose: Centralizes location of important definitions for the ADB3 core
**          driver, such as constants, default values for parameters etc.
**
** (C) Copyright Alpha Data 2009-2014
*/

#if !defined(_ADATA_CORE_DEVICE_DEFS_H)
#define _ADATA_CORE_DEVICE_DEFS_H

/*
** PLX Tech PCI9056/PCI9080/PCI9656-based cards
*/
#define PCI_VENDOR_PLXTECH                      (0x10B5U)
#define PCI_DEVICE_PLXTECH_PCI9056              (0x9056U)
#define PCI_DEVICE_PLXTECH_PCI9080              (0x9080U)
#define PCI_DEVICE_PLXTECH_PCI9656              (0x9656U)

#define PCI_SUBVENDOR_PLXTECH                   (0x10B5U)
#define PCI_SUBDEVICE_PLXTECH_PCI9056           (0x9056U)
#define PCI_SUBDEVICE_PLXTECH_PCI9080           (0x9080U)
#define PCI_SUBDEVICE_PLXTECH_PCI9656           (0x9656U)

#define PCI_SUBVENDOR_PCI9080_ADATA             (0x4144U)
#define PCI_SUBDEVICE_PCI9080_ADMXRC            (0x0040U) /* Could also be an ADM-XRC-P */
#define PCI_SUBDEVICE_PCI9080_ADMXRC2L          (0x0041U)

#define PCI_SUBVENDOR_PCI9656_ADATA             (0x4144U)
#define PCI_SUBDEVICE_PCI9656_ADMXRC2           (0x0042U)
#define PCI_SUBDEVICE_PCI9656_ADPWRC2           (0x0045U)
#define PCI_SUBDEVICE_PCI9656_ADPDRC2           (0x0046U)
#define PCI_SUBDEVICE_PCI9656_ADMXRC4LS         (0x004BU)
#define PCI_SUBDEVICE_PCI9656_ADMXRC4LX         (0x004CU)
#define PCI_SUBDEVICE_PCI9656_ADMXRC4SX         (0x004DU)
#define PCI_SUBDEVICE_PCI9056_ADMPCIE6S1        (0x0080U)

/* Alpha Data PCI Vendor ID */
#define PCI_VENDOR_ADATA                        (0x4144U)

/*
** Alpha Data ADB1-based cards
*/

#define PCI_DEVICE_ADATA_ADMXPL                 (0x0043U)
#define PCI_DEVICE_ADATA_ADMXP                  (0x0044U)
#define PCI_DEVICE_ADATA_ADPXPI                 (0x0049U)
#define PCI_DEVICE_ADATA_ADPEXRC4FX             (0x004EU)
#define PCI_DEVICE_ADATA_ADMXRC4FX              (0x004FU)
#define PCI_DEVICE_ADATA_ADMXRC5LX              (0x0050U)
#define PCI_DEVICE_ADATA_ADMXRC5T1              (0x0051U)
#define PCI_DEVICE_ADATA_ADMXRC5T2              (0x0052U)
#define PCI_DEVICE_ADATA_ADMXRC5LXA             (0x0053U) /* Appears as ADM-XRC-5LX at ADMXRC2 API level, but has hardware differences */
#define PCI_DEVICE_ADATA_ADCPXRC4LX             (0x0054U)
#define PCI_DEVICE_ADATA_ADMAMC5A2              (0x0056U)
#define PCI_DEVICE_ADATA_ADMXRC5TZ              (0x0057U)
#define PCI_DEVICE_ADATA_ADCBBP                 (0x0059U)
#define PCI_DEVICE_ADATA_ADMXRC5T2ADV           (0x005BU)
#define PCI_DEVICE_ADATA_ADMXRC5TDA1            (0x005CU)
#define PCI_DEVICE_ADATA_ADMXRC5T1_VPDBRAM      (0x005DU) /* ADM-XRC-5T1 with VPD hardcoded in BRAM, no Flash device fitted */
#define PCI_DEVICE_ADATA_ADMXRC5T2ADV6          (0x005FU)
#define PCI_DEVICE_ADATA_ADMXRC5T2ADVCC1        (0x0060U)

#define PCI_SUBDEVICE_ADATA_ADMXPL_PCI          (0x0047U)
#define PCI_SUBDEVICE_ADATA_ADMXPL_PCIX         (0x0043U)
#define PCI_SUBDEVICE_ADATA_ADMXP_PCI           (0x0044U)
#define PCI_SUBDEVICE_ADATA_ADMXP_PCIX          (0x0048U)
#define PCI_SUBDEVICE_ADATA_ADPXPI_PCI          (0x0049U)
#define PCI_SUBDEVICE_ADATA_ADPXPI_PCIX         (0x004AU)

/*
** Alpha Data ADB3-based cards
*/

#define PCI_DEVICE_ADATA_ADB3                   (0xADB3U)

#define PCI_SUBVENDOR_ADB3_ADATA                (0x4144U)
#define PCI_SUBDEVICE_ADB3_GENERIC              (0xADB3U)
#define PCI_SUBDEVICE_ADB3_ADPEXRC5T            (0x0100U)
#define PCI_SUBDEVICE_ADB3_ADMXRC6TL_LX50T      (0x0200U)
#define PCI_SUBDEVICE_ADB3_ADMXRC6TL_FX50T      (0x0201U)
#define PCI_SUBDEVICE_ADB3_ADMXRC6T1            (0x0300U)
#define PCI_SUBDEVICE_ADB3_ADMXRC6TGE           (0x0301U)
#define PCI_SUBDEVICE_ADB3_ADMXRC6TADV8         (0x0302U)
#define PCI_SUBDEVICE_ADB3_ADPEXRC6TL           (0x0303U)
#define PCI_SUBDEVICE_ADB3_ADPEXRC6TL_BERT      (0x03FDU)
#define PCI_SUBDEVICE_ADB3_ADMXRC6TADV8_REV2    (0x0304U)
#define PCI_SUBDEVICE_ADB3_ADPEXRC6T            (0x0305U)
#define PCI_SUBDEVICE_ADB3_ADPEXRC6T_BERT       (0x03FCU)
#define PCI_SUBDEVICE_ADB3_ADMXRC6T1_BERT       (0x03FFU)
#define PCI_SUBDEVICE_ADB3_ADPEXRC6TADV_C       (0x0306U)
#define PCI_SUBDEVICE_ADB3_ADPEXRC6TADV_T       (0x0307U)
#define PCI_SUBDEVICE_ADB3_ADMXRC6TDA1          (0x0309U)
#define PCI_SUBDEVICE_ADB3_ADMXRC6TGEL          (0x030AU)
#define PCI_SUBDEVICE_ADB3_ADMXRC6TDA1_BERT     (0x03FEU)
#define PCI_SUBDEVICE_ADB3_ADMXRC7K1_REV1       (0x0700U)
#define PCI_SUBDEVICE_ADB3_ADMXRC7K1_REV2       (0x0704U)
#define PCI_SUBDEVICE_ADB3_ADMXRC7V1            (0x0701U)
#define PCI_SUBDEVICE_ADB3_ADMXRC7V1_PASS2      (0x0703U)
#define PCI_SUBDEVICE_ADB3_ADMVPX37V2           (0x0705U)
#define PCI_SUBDEVICE_ADB3_ADMPCIE7V3           (0x0706U)
#define PCI_SUBDEVICE_ADB3_ADMXRC7Z1            (0x0707U)
#define PCI_SUBDEVICE_ADB3_ADMXRC7Z2            (0x0708U)
#define PCI_SUBDEVICE_ADB3_ADMXRCKU1            (0x0808U)
#define PCI_SUBDEVICE_ADB3_ADMXRCKU1_P5         (0x0803U)
#define PCI_SUBDEVICE_ADB3_ADMXRCKU1_P6         (0x0804U)
#define PCI_SUBDEVICE_ADB3_ADMPCIEKU3           (0x0801U)
#define PCI_SUBDEVICE_ADB3_ADMPCIEKU3_2ND       (0x0802U)
#define PCI_SUBDEVICE_ADB3_ADMPCIE8V3           (0x0805U)
#define PCI_SUBDEVICE_ADB3_ADMPCIE8K5           (0x0807U)

/* Default value if DmaMapLength registry parameter not found */
#define DEFAULT_DMA_MAP_LENGTH                  (32)

/* Maximum number of special (boot) blocks for a legacy Flash bank */
#define FLASH_LEGACY_MAX_NUM_SPECIAL_BLOCK      (4)

#endif
