/*
** File: corewindow.c  
** Project: ADB3 core driver
** Purpose: Window Core Interface functions.
**
** (C) Copyright Alpha Data 2013
*/

#include <df.h>
#include "device.h"
#include "corewindow.h"

unsigned int
coreGetNumWindow(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  return pDevCtx->info.bootstrap.numWindow;
}

CoreWindowStatus
coreGetWindowInfo(
  void* pInterfaceContext,
  unsigned int windowIndex,
  CoreWindowInfo* pInfo)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;
  WindowInfo* pWindowInfo;

  if (windowIndex >= pDevCtx->info.bootstrap.numWindow) {
    return CoreWindowInvalidIndex;
  } else {
    pWindowInfo = &pDevCtx->info.window[windowIndex];
    pInfo->busBase = pWindowInfo->busBase;
    pInfo->busSize = pWindowInfo->busSize;
    pInfo->localBase = pWindowInfo->localBase;
    pInfo->localSize = pWindowInfo->localSize;
    pInfo->translatedBase = pWindowInfo->translatedBase;
    pInfo->translatedSize = pWindowInfo->translatedSize;
    pInfo->pKernelBase = pWindowInfo->pKernelBase;
    pInfo->kernelSize = pWindowInfo->kernelSize;
    return CoreWindowSuccess;
  }
}

CoreWindowAddressStatus
coreGetWindowAddress(
  void* pInterfaceContext,
  unsigned int windowIndex,
  size_t offset,
  size_t length,
  void** pKernelAddress)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;
  WindowInfo* pWindowInfo;

  if (windowIndex >= pDevCtx->info.bootstrap.numWindow) {
    return CoreWindowAddressInvalidIndex;
  } else {
    pWindowInfo = &pDevCtx->info.window[windowIndex];
    if (offset >= pWindowInfo->kernelSize || length > pWindowInfo->kernelSize || offset + length > pWindowInfo->kernelSize) {
      return CoreWindowAddressInvalidRegion;
    }
    *pKernelAddress = (uint8_t*)pWindowInfo->pKernelBase + offset;
    return CoreWindowAddressSuccess;
  }
}

CoreWindowConfigStatus
coreGetWindowConfig(
  void* pInterfaceContext,
  unsigned int windowIndex,
  CoreWindowConfig* pConfig)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (windowIndex >= pDevCtx->info.bootstrap.numWindow) {
    return CoreWindowAddressInvalidIndex;
  }
  return pDevCtx->methods.pWindowConfig(pDevCtx, windowIndex, FALSE, 0, pConfig);
}

CoreWindowConfigStatus
coreSetWindowConfig(
  void* pInterfaceContext,
  unsigned int windowIndex,
  uint32_t flags,
  const CoreWindowConfig* pConfig)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (windowIndex >= pDevCtx->info.bootstrap.numWindow) {
    return CoreWindowAddressInvalidIndex;
  }
  return pDevCtx->methods.pWindowConfig(pDevCtx, windowIndex, TRUE, flags, (CoreWindowConfig*)pConfig);
}
