/*
** File: corenotify.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for registering and unregistering for
**          notifications in Core Interface.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_CORENOTIFY_H)
#define ADATA_CORE_CORENOTIFY_H

#include <df.h>
#include "device.h"
#include "coreif.h"

extern void
coreNotifyListeners(
  Adb3CoreDeviceContext* pDevCtx,
  Adb3CoreNotificationList* pList);

extern boolean_t
coreNotificationReg(
  void* pInterfaceContext,
  unsigned int notifyType,
  CoreNotification* pNotification,
  CoreNotificationCallback* pCallback,
   void* pCallbackContext);

extern boolean_t
coreNotificationUnreg(
  void* pInterfaceContext,
  CoreNotification* pNotification);

#endif
