/*
** File: coremisc.c  
** Project: ADB3 core driver
** Purpose: Miscellaneous Core Interface functions.
**
** (C) Copyright Alpha Data 2009-2010
*/

#include <df.h>
#include "device.h"
#include "coremisc.h"

unsigned int
coreGetNumDmaChannel(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  return pDevCtx->info.bootstrap.numDmaChannel;
}

void
coreClearDeviceErrors(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (NULL != pDevCtx->methods.pClearErrors) {
    pDevCtx->methods.pClearErrors(pDevCtx);
  }
}

void
coreGetDeviceStatus(
  void* pInterfaceContext,
  CoreDeviceStatus* pDeviceStatus)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  dfZeroMemory(pDeviceStatus, sizeof(*pDeviceStatus));
  if (NULL != pDevCtx->methods.pGetDeviceStatus) {
    pDevCtx->methods.pGetDeviceStatus(pDevCtx, pDeviceStatus);
  }
}
