/*
** File: coredma.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for DMA transfers in Core Interface.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_COREDMA_H)
#define ADATA_CORE_COREDMA_H

#include <df.h>
#include "device.h"
#include "coreif.h"

extern void
dmaCompletedRoutine(
  DfDpc* pDpc,
  void* pContext, /* channel */
  void* pArg);

#if defined(BUILD_DEBUGTS)
DF_DECLARE_INLINE_FUNC(void, dmaLogIsrTimestamp)(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int channelIndex)
{
  DmaChannelContext* pDmaContext = &pDevCtx->dma.channel[channelIndex];

  /* Save timestamp rather than logging it to buffer here, because that would require
  ** a spinlock to be acquired, which is illegal in interrupt context (on Windows) */
  if (dfTimestampBufferEnabled(&pDmaContext->timestampBuffer)) {
    pDmaContext->isrTimestamp = dfTimestampGet();
  }
}
#endif

extern CoreDmaStatus
coreDmaCancel(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int channelIndex);

extern CoreDmaStatus
coreDmaInitialize(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int channelIndex,
  const CoreDmaParameters* pParameters,
  CoreDmaCallback* pCallback,
  void* pCallbackContext);

extern void
coreDmaStart(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int channelIndex);

#endif
