/*
** File: coredebugts.h  
** Project: ADB3 core driver
** Purpose: Defines prototypes for debug timestamping facility in Core Interface.
**
** (C) Copyright Alpha Data 2016
*/

#if !defined(ADATA_CORE_COREDEBUGTS_H)
#define ADATA_CORE_COREDEBUGTS_H

#include <df.h>
#include "coreif.h"

CoreDebugTSResult
coreGetDebugTSInfo(
  void* pDevice,
  unsigned int facility,
  CoreDebugTSInfo* pDebugTSInfo);

CoreDebugTSResult
coreGetDebugTSStatus(
  void* pDevice,
  unsigned int facility,
  CoreDebugTSStatus* pDebugTSStatus);

CoreReadDebugTSResult
coreReadDebugTS(
  void* pDevice,
  unsigned int facility,
  size_t offset,
  size_t count,
  uint32_t flags,
  void* pBuffer);

CoreDebugTSResult
coreResetDebugTS(
  void* pDevice,
  unsigned int facility);

#endif
