/*
** File: avr_clock.h  
** Project: ADB3 core driver
** Purpose: Exports definitions for programing clock generators via the
**          AVR uC
**
** (C) Copyright Alpha Data 2012
*/

#ifndef _ADATA_CORE_AVR_CLOCK_H
#define _ADATA_CORE_AVR_CLOCK_H

#include "avr_common.h"

struct _AvrClockRequest;
typedef struct _AvrClockRequest AvrClockRequest;
struct _AvrClockRequestSync;
typedef struct _AvrClockRequestSync AvrClockRequestSync;

typedef enum _AvrClockStatus {
  AvrClockStatusSuccess         = 0,    /* Success */
  AvrClockStatusTimeout         = 1,    /* AVR uC didn't respond within allotted time */
  AvrClockStatusServiceMode     = 2,    /* AVR uC is in service mode */
  AvrClockStatusOutOfRange      = 3,    /* Frequency is outside valid range */
  AvrClockStatusInvalidIndex    = 4,    /* Index of clock generator is invalid */
  AvrClockStatusGeneralFailure  = 5     /* Failed for reason that can't be determined */
} AvrClockStatus;

#define AVR_CLOCK_MAX_CLOCKS (4)

typedef struct _AvrClockGenContext {
  unsigned int index;
  union { /* Memory for AVR transactions */
    struct { /* AVR "GF" command */
      AvrTransRequest request;
      uint8_t command[4];
      uint8_t reply[8];
    } getFrequency;
    struct { /* AVR "SF" command */
      AvrTransRequest request;
      uint8_t command[8];
      uint8_t reply[8];
    } setFrequency;
  } transaction;
  struct { /* Used to save & restore state when powering down & up */
    uint32_t lastFrequency;
    boolean_t bLastValid;
  } save;
} AvrClockGenContext;

typedef struct _AvrClockContext {
  AvrDeviceContext* pAvrDevCtx;
  unsigned int numClock;
  AvrClockGenContext clocks[AVR_CLOCK_MAX_CLOCKS];
} AvrClockContext;

typedef void AvrClockGetFrequencyCallback(AvrClockContext* pAvrClockCtx, AvrClockRequest* pRequest, AvrClockStatus status, unsigned int index, uint32_t frequency, void* pContext);
typedef void AvrClockSetFrequencyCallback(AvrClockContext* pAvrClockCtx, AvrClockRequest* pRequest, AvrClockStatus status, unsigned int index, void* pContext);

struct _AvrClockRequest {
  AvrClockContext* pAvrClockCtx;
  struct {
    AvrClockGetFrequencyCallback* pGetFrequency;
    AvrClockSetFrequencyCallback* pSetFrequency;
  } callback;
  void* pContext;
  unsigned int index;
};

struct _AvrClockRequestSync {
  AvrClockRequest request;
  DfEvent ev;
  AvrClockStatus status;
  uint32_t frequency;
};

#endif
