/*
** File: avr2_clock.h  
** Project: ADB3 core driver
** Purpose: Exports definitions for programing clock generators via the
**          AVR2 interface
**
** (C) Copyright Alpha Data 2015
*/

#ifndef _ADATA_CORE_AVR2_CLOCK_H
#define _ADATA_CORE_AVR2_CLOCK_H

#include "avr2_common.h"

struct _Avr2ClockRequest;
typedef struct _Avr2ClockRequest Avr2ClockRequest;
struct _Avr2ClockRequestSync;
typedef struct _Avr2ClockRequestSync Avr2ClockRequestSync;

typedef enum _Avr2ClockStatus {
  Avr2ClockStatusSuccess         = 0,    /* Success */
  Avr2ClockStatusTimeout         = 1,    /* AVR uC didn't respond within allotted time */
  Avr2ClockStatusServiceMode     = 2,    /* AVR uC is in service mode */
  Avr2ClockStatusOutOfRange      = 3,    /* Frequency is outside valid range */
  Avr2ClockStatusInvalidIndex    = 4,    /* Index of clock generator is invalid */
  Avr2ClockStatusGeneralFailure  = 5     /* Failed for reason that can't be determined */
} Avr2ClockStatus;

#define AVR2_CLOCK_MAX_CLOCKS (4)

typedef struct _Avr2ClockGenContext {
  unsigned int index;
  union { /* Memory for AVR2 transactions */
    struct { /* AVR "GF" command */
      Avr2TransRequest request;
      uint8_t command[3];
      uint8_t reply[7];
    } getFrequency;
    struct { /* AVR "SF" command */
      Avr2TransRequest request;
      uint8_t command[7];
      uint8_t reply[7];
    } setFrequency;
  } transaction;
  struct { /* Used to save & restore state when powering down & up */
    uint32_t lastFrequency;
    boolean_t bLastValid;
  } save;
} Avr2ClockGenContext;

typedef struct _Avr2ClockContext {
  Avr2DeviceContext* pAvr2DevCtx;
  unsigned int numClock;
  Avr2ClockGenContext clocks[AVR2_CLOCK_MAX_CLOCKS];
} Avr2ClockContext;

typedef void Avr2ClockGetFrequencyCallback(Avr2ClockContext* pAvr2ClockCtx, Avr2ClockRequest* pRequest, Avr2ClockStatus status, unsigned int index, uint32_t frequency, void* pContext);
typedef void Avr2ClockSetFrequencyCallback(Avr2ClockContext* pAvr2ClockCtx, Avr2ClockRequest* pRequest, Avr2ClockStatus status, unsigned int index, void* pContext);

struct _Avr2ClockRequest {
  Avr2ClockContext* pAvr2ClockCtx;
  struct {
    Avr2ClockGetFrequencyCallback* pGetFrequency;
    Avr2ClockSetFrequencyCallback* pSetFrequency;
  } callback;
  void* pContext;
  unsigned int index;
};

struct _Avr2ClockRequestSync {
  Avr2ClockRequest request;
  DfEvent ev;
  Avr2ClockStatus status;
  uint32_t frequency;
};

#endif
