/*
** File: avr2.h  
** Project: ADB3 core driver
** Purpose: Exports definitions for the the AVR2 uC interface
**
** (C) Copyright Alpha Data 2015
*/

#ifndef _ADATA_CORE_AVR2_H
#define _ADATA_CORE_AVR2_H

#include <df.h>

/* AVR2 control register fields */
/*    11 - (WO)  1 => Advance RX FIFO read pointer */
/*    10 - (WO)  1 => Write [9:0] into TX FIFO */
/*    9  - (WO)  1 => End of packet indicator */
/*    8  - (WO)  1 => Start of packet indicator */
/*  7:0  - (WO)  Byte to queue in TX FIFO */
#define AVR2_CTL_S_DATA            (0)
#define AVR2_CTL_L_DATA            (8)
#define AVR2_CTL_M_DATA            DF_MASK32S(AVR2_CTL_S_DATA, AVR2_CTL_L_DATA)
#define AVR2_CTL_E_DATA(x)         DF_VAL32S(x, AVR2_CTL_S_DATA, AVR2_CTL_L_DATA)
#define AVR2_CTL_V_SOH             DF_VAL32S(0x1U, 8, 1)
#define AVR2_CTL_V_EOT             DF_VAL32S(0x1U, 9, 1)
#define AVR2_CTL_V_WRITE           DF_VAL32S(0x1U, 10, 1)
#define AVR2_CTL_V_ADVANCE         DF_VAL32S(0x1U, 11, 1)

/* AVR2 status register fields */
/*    31 - (RO/W1C)  1 => Sensor update occurred at least once */
/*    30 - (RO/W1C)  1 => VPD update occurred at least once */
/*    29 - (RO/W1C)  1 => XRM/FMC information update occurred at least once */
/* 28:18 - (RO)  (reserved) */
/*    17 - (RO)  1 => AVR is in service mode */
/*    16 - (RO)  1 => TX error (protocol error) detected */
/*    15 - (RO)  1 => TX FIFO empty */
/*    14 - (RO)  1 => TX FIFO full */
/*    13 - (RO)  1 => RX FIFO full */
/*    12 - (RO)  1 => RX FIFO empty */
/*    11 -       (reserved) */
/*    10 -       (reserved) */
/*    9  - (RO)  1 => End of packet indicator */
/*    8  - (RO)  1 => Start of packet indicator */
/*  7:0  - (RO)  Byte at head of RX FIFO */
#define AVR2_STAT_S_DATA           (0)
#define AVR2_STAT_L_DATA           (8)
#define AVR2_STAT_M_DATA           DF_MASK32S(AVR2_STAT_S_DATA, AVR2_STAT_L_DATA)
#define AVR2_STAT_E_DATA(x)        DF_EX8S(x, AVR2_STAT_S_DATA, AVR2_STAT_L_DATA)
#define AVR2_STAT_V_SOH            DF_VAL32S(0x1U, 8, 1)
#define AVR2_STAT_V_EOT            DF_VAL32S(0x1U, 9, 1)
#define AVR2_STAT_V_RX_EMPTY       DF_VAL32S(0x1U, 12, 1)
#define AVR2_STAT_V_RX_FULL        DF_VAL32S(0x1U, 13, 1)
#define AVR2_STAT_V_TX_FULL        DF_VAL32S(0x1U, 14, 1)
#define AVR2_STAT_V_TX_EMPTY       DF_VAL32S(0x1U, 15, 1)
#define AVR2_STAT_V_TX_ERROR       DF_VAL32S(0x1U, 16, 1)
#define AVR2_STAT_V_SERVICEMODE    DF_VAL32S(0x1U, 17, 1)
#define AVR2_STAT_V_MEZ_UPDATED    DF_VAL32S(0x1U, 29, 1)
#define AVR2_STAT_V_VPD_UPDATED    DF_VAL32S(0x1U, 30, 1)
#define AVR2_STAT_V_SNS_UPDATED    DF_VAL32S(0x1U, 31, 1)

/* AVR2 control register 2 fields */
/*    0  - (WO)  1 => Reset & flush FX FIFO visible to driver */
#define AVR2_CTL2_V_RESET_DRV      DF_VAL32S(0x1U, 0, 1)

/* AVR2 status register 2 fields */
/*    2  - (RO)  1 => RX error (protocol error) detected */
#define AVR2_STAT2_V_RX_ERROR      DF_VAL32S(0x1U, 2, 1)

/* AVR2 Version response */
typedef struct _Avr2ResponseVersion {
	uint16_t nMajorRelease;
	uint16_t nMinorRelease;
	uint16_t nMajorBuild;
	uint16_t nMinorBuild;
} Avr2ResponseVersion;

/* AVR2 FMC/XRM Status field values */
#define AVR2_MEZ_STAT_V_PRES_A    (0x1U << 0) /* FMC & XRM */
#define AVR2_MEZ_STAT_V_VIO_EN    (0x1U << 1) /* FMC & XRM */
#define AVR2_MEZ_STAT_V_PWROK_M2C (0x1U << 2) /* FMC only */
#define AVR2_MEZ_STAT_V_I2CFAIL   (0x1U << 3) /* FMC & XRM */
#define AVR2_MEZ_STAT_V_CSUMERR   (0x1U << 4) /* FMC & XRM */
#define AVR2_MEZ_STAT_V_DATAERR   (0x1U << 5) /* FMC & XRM */
#define AVR2_MEZ_STAT_V_PRES_C    (0x1U << 6) /* FMC only */
#define AVR2_MEZ_STAT_V_PRES_B    (0x1U << 7) /* FMC only */
#define AVR2_MEZ_STAT_V_FORCE2V5  (0x1U << 7) /* XRM only */

#endif
