/*
** File: adpdrc2.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADP-DRC-II
**
** (C) Copyright Alpha Data 2014
*/

#if !defined(_ADATA_CORE_ADPDRC2_H)
#define _ADATA_CORE_ADPDRC2_H

#include "pci9xxx.h"

/* Model-specific registers in PCI9xxx BAR3 */
/* Same on ADP-DRC-II & ADP-WRC-II */
#pragma pack(1)
typedef struct _ModelRegsAdpdrc2 {
	uint8_t fcon;           /* 0x00 */
	uint8_t ccon;           /* 0x01 */
	uint8_t imset;          /* 0x02 */
	uint8_t imclr;          /* 0x03 */
	uint8_t icon;           /* 0x04 */
	uint8_t pstat;          /* 0x05 */
	uint8_t mode;           /* 0x06 */
	uint8_t _reserved1[1];  /* 0x07 */
	uint8_t smap[4];        /* 0x08 */
	uint32_t fladdr;        /* 0x0C */
	uint8_t fldata;         /* 0x10 */
	uint8_t _reserved2[3];  /* 0x11 */
} ModelRegsAdpdrc2;       /* 0x14 */
#pragma pack()

/* Fields for ModelRegsAdmxrc2::fcon */
#define ADPDRC2_FCON_PROG ((uint8_t)(1U << 0))
#define ADPDRC2_FCON_INIT ((uint8_t)(1U << 1))
#define ADPDRC2_FCON_DONE ((uint8_t)(1U << 2))

/* Fields for ModelRegsAdmxrc2::icon register */
#define ADPDRC2_ICON_FPGA (0x1U << 0)

/* Vital Product data; always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdpdrc2Rev0 {
  uint16_t modifications; /* 0x00 (0x6A) Modifications bitmap; nothing defined yet */
  struct {                /* 0x02 (0x6C, 0x6E, 0x70, 0x72) SDRAM memory bank info */
    uint8_t order;        /* +0 Log2 of number of logical memory words */
    uint8_t type;         /* +1 Either ADMXRC2_RAM_SDRAM_DDR or ADMXRC2_RAM_SDRAM_SDR */
  } sdram[4];
  struct {                /* 0x0A (0x74) SSRAM memory bank info */
    uint8_t order;        /* +0 Log2 of number of logical memory words */
    uint8_t attr;         /* +1 bit [7] = 1 => has ECC (72 bits wide), 0 => no ECC, 64 bits wide */
  } ssram[1];
  uint16_t cardId;        /* 0x0C (0x76) Card ID */
  uint16_t fpgaType;      /* 0x0E (0x78) Device fitted; see ADMXRC2_FPGA_TYPE */
  uint16_t serialNumLo;   /* 0x10 (0x7A) Serial number low 16 bits */
  uint16_t serialNumHi;   /* 0x12 (0x7C) Serial number high 16 bits */
  uint8_t  cpldRev;       /* 0x14 (0x7E) CPLD revision */
  uint8_t  pcbRev;        /* 0x15 (0x7F) Board revision */
} VpdAdpdrc2Rev0;         /* 0x16 (0x80) */
#pragma pack()

/* Byte address of VpdAdpdrc2Rev0 structure in PCI9656's configuration EEPROM */
#define ADPDRC2_EEPROM_VPD_OFFSET (0x6AU)

/* Vital Product data; always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdpwrc2Rev0 {
  uint16_t modifications; /* 0x00 (0x6A) Modifications bitmap; nothing defined yet */
  uint16_t _reserved1[3]; /* 0x02 (0x6C) (Reserved) */
  struct {                /* 0x08 (0x72, 0x74) SDRAM memory bank info */
    uint8_t order;        /* +0 Log2 of number of logical memory words */
    uint8_t _reserved1;   /* +1 (Reserved) */
  } sdram[2];
  uint16_t cardId;        /* 0x0C (0x76) Card ID */
  uint16_t fpgaType;      /* 0x0E (0x78) Device fitted; see ADMXRC2_FPGA_TYPE */
  uint16_t serialNumLo;   /* 0x10 (0x7A) Serial number low 16 bits */
  uint16_t serialNumHi;   /* 0x12 (0x7C) Serial number high 16 bits */
  uint8_t  cpldRev;       /* 0x14 (0x7E) CPLD revision */
  uint8_t  pcbRev;        /* 0x15 (0x7F) Board revision */
} VpdAdpwrc2Rev0;         /* 0x16 (0x80) */
#pragma pack()

/* Byte address of VpdAdpwrc2Rev0 structure in PCI9656's configuration EEPROM */
#define ADPWRC2_EEPROM_VPD_OFFSET (0x6AU)

#endif
