/*
** File: admxrc6tx_common.h  
** Project: ADB3 core driver
** Purpose: Prototypes of common ADMXRC6TL / ADMXRC6T1 methods
**
** (C) Copyright Alpha Data 2010-2012
*/

#ifndef _ADATA_CORE_ADMXRC6TX_COMMON_H
#define _ADATA_CORE_ADMXRC6TX_COMMON_H

#include "device.h"

extern boolean_t
admxrc6txI2cXrmIdentify(
	Adb3CoreDeviceContext* pDevCtx,
  I2cContext* pI2cCtx);

extern unsigned int
admxrc6txInitSensorInfoLm87(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int sensorIndex);

extern unsigned int
admxrc6txInitSensorInfoXsmon(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int sensorIndex,
  boolean_t bAlternateNaming);

extern unsigned int
admxrc6txInitSensorInfoDiag(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int sensorIndex);

extern CoreSensorStatus
admxrc6txReadSensorLm87(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int lm87SensorIndex,
  CoreSensorValue* pReading);

extern CoreSensorStatus
admxrc6txReadSensorXsmon(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int xsMonSensorIndex,
  CoreSensorValue* pReading);

extern CoreSensorStatus
admxrc6txReadSensorDiag(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int xsMonSensorIndex,
  CoreSensorValue* pReading);

extern CoreSensorStatus
admxrc6txReadSensor(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int sensorIndex,
  CoreSensorValue* pReading);

extern void
admxrc6txI2cStart(
	I2cContext* pI2cCtx,
  uint8_t bus,
  uint8_t slot,
  uint8_t address,
  boolean_t bWrite,
  uint8_t data,
  void* pContext);

extern boolean_t
admxrc6txI2cPoll(
	I2cContext* pI2cCtx,
  boolean_t bWrite,
  uint8_t* pData,
  boolean_t* pbSuccess,
  void* pContext);

extern boolean_t
admxrc6txXrmReadByte(
	I2cContext* pI2cCtx,
  uint8_t address,
  uint8_t* pVal8);

extern boolean_t
admxrc6txXrmWriteByte(
	I2cContext* pI2cCtx,
  uint8_t address,
  uint8_t val8);

extern unsigned int g_admxrc6txNumDiagSensor;

extern CoreVpdStatus
admxrc6txReadWriteVpd(
	Adb3CoreDeviceContext* pDevCtx,
	boolean_t bWrite,
	size_t address,
	size_t length,
	void* pData);

extern CoreVpdStatus
admxrc6txSyncVpd(
	Adb3CoreDeviceContext* pDevCtx);

extern void
admxrc6txFlashResetBank(
  Adb3CoreDeviceContext* pDevCtx,
  FlashRegsAdmxrc6tx* pFlashRegs);

extern void
admxrc6txFlashBank(
  Adb3CoreDeviceContext* pDevCtx,
  FlashRegsAdmxrc6tx* pFlashRegs,
  boolean_t bWrite,
  uint64_t location,
  uint32_t* pValue);

extern void
admxrc6txFlashSingleBank(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int bankIndex,
  boolean_t bWrite,
  uint64_t location,
  uint32_t* pValue);

/* Get data from AVR VPD area */
extern CoreVpdStatus
admxrc6txReadAvrVpdData(
  Adb3CoreDeviceContext* pDevCtx,
  uint16_t address,
  size_t n,
  void* pBuffer);

/* Verify VPD structure in AVR VPD area */
extern boolean_t
admxrc6txVerifyAvrVpdChecksum(
	Adb3CoreDeviceContext* pDevCtx,
  uint16_t vpdLength);

#endif
