/*
** File: admxrc6tge.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-6T1.
**
** (C) Copyright Alpha Data 2011
*/

#ifndef _ADATA_CORE_ADMXRC6TGE_H
#define _ADATA_CORE_ADMXRC6TGE_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"

#define ADMXRC6TGE_NUM_DMA_CHANNEL  (4)
#define ADMXRC6TGEL_NUM_DMA_CHANNEL (2)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxrc6tgeRev0 {
	uint16_t version;       /* Revision of this structure (0) */
	uint16_t length;        /* Length of this structure including checksum */
	uint32_t serial;
	uint32_t modifications;
	uint32_t si5338Ref;     /* Frequency of SI5338 reference oscillator, in Hz */
	uint32_t idelayRef;     /* IDELAY reference clock frequency, in Hz */
	struct {
		uint16_t speed;       /* In units of 100 kHz */
		uint8_t	 order;       /* Log base 2 of size in words */
    uint8_t  _reserved1;
    uint16_t link;        /* Byte offset in VPD of extended info */
    uint16_t _reserved2;
	} sdram[4];
  struct {
    uint8_t  stepping[8];
    uint8_t  speedGrade[4];
    uint16_t device;
    uint8_t  tempGrade;
    uint8_t  _reserved3;
  } fpga;
	uint8_t  pcbRev;
	uint8_t  cpldRev;
  uint8_t  _reserved4;
  uint8_t  checksum;      /* This MUST ALWAYS be the last member in the struct */
} VpdAdmxrc6tgeRev0;
#pragma pack()

/* Values for VpdAdmxrc6tgeRev0::modifications */
#define ADMXRC6TGE_VPD_MOD_NOTFITTED_XMC_PN6 (0x1U << 0U) /* XMC P16 connector NOT fitted */
#define ADMXRC6TGE_VPD_MOD_NOTFITTED_XMC_PN4 (0x1U << 1U) /* PMC Pn4 connector NOT fitted */
#define ADMXRC6TGE_VPD_MOD_GIGE_PN6          (0x1U << 2U) /* Has Gigabit Ethernet instead of 4 Pn6 lanes */
#define ADMXRC6TGE_VPD_MOD_MGTREFCLK_PN6     (0x1U << 3U) /* Has an MGT reference clock on 2 Pn6 pins */

/* Values for VpdAdmxrc6tgeRev0::fpga::tempGrade */
#define ADMXRC6TGE_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADMXRC6TGE_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADMXRC6TGE_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

/* Values for ADMXRC6Tx_V_I2CCTL_I2CADDR() */
#define ADMXRC6TGE_I2C_SLOT_SI5338           (0x70U)

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADMXRC6TGE_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL)

#endif
