/*
** File: admxrc6tda1.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-6T-DA1.
**
** (C) Copyright Alpha Data 2012
*/

#ifndef _ADATA_CORE_ADMXRC6TDA1_H
#define _ADATA_CORE_ADMXRC6TDA1_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"

#define ADMXRC6TDA1_NUM_DMA_CHANNEL (4U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxrc6tda1Rev0 {
	uint16_t version;       /* Revision of this structure (0) */
	uint16_t length;        /* Length of this structure including checksum */
	uint32_t serial;
	uint32_t modifications;
	uint32_t idelayRef;     /* IDELAY reference clock frequency, in Hz */
	uint32_t mgtRef;        /* MGT reference clock frequency, in Hz */
	struct {
		uint16_t speed;       /* In units of 100 kHz */
		uint8_t	 order;       /* Log base 2 of size in words */
    uint8_t  _reserved1;
    uint16_t link;        /* Byte offset in VPD of extended info */
    uint16_t _reserved2;
	} sdram[4];
  struct {
    uint8_t  stepping[8];
    uint8_t  speedGrade[4];
    uint16_t device;
    uint8_t  tempGrade;
    uint8_t  _reserved1;
  } fpga;
	uint8_t  pcbRev;
	uint8_t  cpldRev;
  uint16_t  _reserved1;
  struct {
    uint16_t speed;       /* In units of 100 kHz */
    uint8_t resolution;   /* Number of bits of resolution */
    uint8_t flags;        /* Flags bitmask: 0x1 => RF variant */
  } adc;
  struct {
    uint16_t speed;       /* In units of 100 kHz */
    uint8_t resolution;   /* Number of bits of resolution */
    uint8_t flags;        /* Flags bitmask: (nothing defined yet) */
  } dac;
  uint8_t  checksum;      /* This MUST ALWAYS be the last member in the struct */
} VpdAdmxrc6tda1Rev0;
#pragma pack()

/* Values for VpdAdmxrc6t1Rev0::modifications */
#define ADMXRC6TDA1_VPD_MOD_NOTFITTED_XMC_PN6 (0x1U << 0U) /* XMC P16 connector NOT fitted */
#define ADMXRC6TDA1_VPD_MOD_NOTFITTED_XMC_PN4 (0x1U << 1U) /* PMC Pn4 connector NOT fitted */

/* Values for VpdAdmxrc6t1Rev0::fpga::tempGrade */
#define ADMXRC6TDA1_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADMXRC6TDA1_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADMXRC6TDA1_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADMXRC6TDA1_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL)

#endif
