/*
** File: admxrc5t2.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to:
**   o ADM-XRC-5T2
**   o ADM-XRC-5T2-ADV
**   o ADM-XRC-5T2-ADV6
**   o ADM-XRC-5T2-ADV-CC1
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(_ADATA_CORE_ADMXRC5T2_H)
#define _ADATA_CORE_ADMXRC5T2_H

#include "adb1.h"

#define ADMXRC5T2_NUM_DMA_CHANNEL (4U)

/* Address and size of VPD region in Flash */
#define ADMXRC5T2_VPD_OFFSET_IN_FLASH (0U)
#define ADMXRC5T2_VPD_SIZE_IN_FLASH   (0x20000U)

/* Beginning of useable area in Flash for storing target bitstreams */
#define ADMXRC5T2_FLASH_TARGET_AREA_START (0x800000U)

/* Number of sensors in ADM-XRC-5T2 */
#define ADMXRC5T2_NUM_LM87_SENSOR (10U)

/* Number of sensors in ADM-XRC-5T2-ADV & ADM-XRC-5T2-ADV6 */
#define ADMXRC5T2ADVx_NUM_LM87_SENSOR (10U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxrc5t2Rev0 {
  uint16_t version;        /* 0x00 */
  uint16_t boardType;      /* 0x02 */
  uint32_t modifications;  /* 0x04 */
  uint8_t stepping;        /* 0x08 */
  uint8_t tempGrade;       /* 0x09 */
  uint8_t reserved1[2];    /* 0x0A */
  uint32_t scd;            /* 0x0C */
  uint32_t lclkRef;        /* 0x10 */
  uint32_t mclkARef;       /* 0x14 */
  uint32_t mclkBRef;       /* 0x18 */
  uint32_t _reserved2;     /* 0x1C */
  struct {
    uint8_t order;         /* 0x20, 0x22, 0x24, 0x26 */
    uint8_t _reserved3;    /* 0x21, 0x23, 0x25, 0x27 */
  } sdram[4];
  struct {
    uint8_t order;         /* 0x28, 0x2A */
    uint8_t _reserved4;    /* 0x29, 0x2B */
  } ssram[2];
  uint32_t _reserved5;     /* 0x2C */
  uint32_t cardId;         /* 0x30 */
  uint32_t serialNumber;   /* 0x34 */
  uint16_t fpgaType;       /* 0x38 */
  uint8_t pcbRev;          /* 0x3A */
  uint8_t cpldRev;         /* 0x3B */
} VpdAdmxrc5t2Rev0;        /* 0x3C */
#pragma pack()

#endif
