/*
** File: admxrc4.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-4LX & ADM-XRC-4SX.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(_ADATA_CORE_ADMXRC4_H)
#define _ADATA_CORE_ADMXRC4_H

#include "pci9xxx.h"

#pragma pack(1)
typedef struct _ModelRegsAdmxrc4 {
  uint32_t revision;          /* 0x000000 */
  uint32_t _reserved1[1];     /* 0x000004 */
  uint32_t lclk;              /* 0x000008 */
  uint32_t mclk;              /* 0x00000C */
  uint32_t fpctl;             /* 0x000010 */
  uint32_t _reserved2[3];     /* 0x000014 */
  uint32_t ictl;              /* 0x000020 */
  uint32_t istat;             /* 0x000024 */
  uint32_t pwrctl;            /* 0x000028 */
  uint32_t _reserved3[53];    /* 0x00002C */
  uint32_t flctl;             /* 0x000100 */
  uint32_t flpage;            /* 0x000104 */
  uint32_t fldata;            /* 0x000108 */
  uint32_t _reserved4[13];    /* 0x00010C */
  uint32_t flbuf[16];         /* 0x000140 */
  uint32_t _reserved5[32];    /* 0x000180 */
  uint32_t xrmid[17];         /* 0x000200 */
  uint32_t _reserved6[111];   /* 0x000244 */
  uint32_t sysmonctl[64];     /* 0x000400 */
  uint32_t sysmonbuf[64];     /* 0x000500 */
  uint32_t _reserved7[32384]; /* 0x000600 */
  uint32_t fpsmap[32768];     /* 0x020000 */
  uint32_t parjtag[32768];    /* 0x040000 */
  uint32_t _reserved8[32768]; /* 0x060000 */
  uint32_t flash[65536];      /* 0x080000 */
  uint32_t _reserved9[65536]; /* 0x100000 */
} ModelRegsAdmxrc4;
#pragma pack()

/* Fields for ModelRegsAdmxrc4::fpctl */
#define ADMXRC4_FPCTL_PROG (0x1U << 0)
#define ADMXRC4_FPCTL_INIT (0x1U << 1)
#define ADMXRC4_FPCTL_DONE (0x1U << 2)

/* Fields for ModelRegsAdmxrc4::ictl */
#define ADMXRC4_ICTL_ENFPGA (0x1U << 0)

/* Fields for ModelRegsAdmxrc4::istat */
#define ADMXRC4_ISTAT_IRQFPGA (0x1U << 0)

/* Byte address of VPD structure below in PCI9656's EEPROM */
#define ADMXRC4_EEPROM_VPD_OFFSET (0x6CU)

/*
** Always LITTLE ENDIAN when stored in hardware.
**
** For fields 'banks01', 'banks23' & 'banks45', information is laid out as follows:
**
** [7:6] (Bank n+1) 2'b00 => 8 Mib / 1 MiB, 2'b01 => 16 Mib / 2 MiB, 2'b10 => 32 Mib / 4 MiB, 2'b11 => 64 Mib / 8 MiB.
** [5:4] (Bank n+1) 2'b00 => Not fitted,     2'b01 => Flowthrough ZBT,  2'b10 => Pipelined ZBT,  2'b11 => Flowthrough & pipelined.
** [3:2] (Bank n)   2'b00 => 8 Mib / 1 MiB, 2'b01 => 16 Mib / 2 MiB, 2'b10 => 32 Mib / 4 MiB, 2'b11 => 64 Mib / 8 MiB.
** [1:0] (Bank n)   2'b00 => Not fitted,     2'b01 => Flowthrough ZBT,  2'b10 => Pipelined ZBT,  2'b11 => Flowthrough & pipelined.
**
** where 'n' is 0 for 'banks01' field, 2 for 'banks23' field or 4 for 'banks45' field.
**
** On the ADM-XRC-4SX, the 'banks45' field is reserved, since it has only 4 banks of ZBT SSRAM.
*/
#pragma pack(1)
typedef struct _VpdAdmxrc4Rev0 {
  uint16_t modifications; /* 0x00 (0x6C) Modifications bitmap; nothing defined yet */
  uint16_t oscType;       /* 0x02 (0x6E) Reference clock oscillator type; 1 => 14.31818MHz */
  uint16_t flashType;     /* 0x04 (0x70) Flash type; 2 => Common Flash Interface (CFI) device */
  uint8_t  banks01;       /* 0x06 (0x72) ZBT SSRAM banks 0 and 1 information; see comment above */
  uint8_t  banks23;       /* 0x07 (0x73) ZBT SSRAM banks 2 and 3 information; see comment above */
  uint8_t  banks45;       /* 0x08 (0x74) ZBT SSRAM banks 4 and 5 information; see comment above */
  uint8_t _reserved1;     /* 0x09 (0x75) (Reserved)*/
  uint16_t cardId;        /* 0x0A (0x76) Card ID */
  uint16_t fpgaType;      /* 0x0C (0x78) Device fitted; see ADMXRC2_FPGA_TYPE */
  uint16_t serialLow;     /* 0x0E (0x7A) Bits [15:0] of serial number */
  uint16_t serialHigh;    /* 0x10 (0x7C) Bits [31:16] of serial number */
  uint8_t  logicRev;      /* 0x12 (0x7E) Controller revision; 0xAB => A.B */
  uint8_t  boardRev;      /* 0x13 (0x7F) Board revision; 0xCD => C.D */
} VpdAdmxrc4Rev0;         /* 0x14 (0x80) */
#pragma pack()

/* Frequency of the reference oscillator used for ICS307 and ICS8430-61 clock generators */
#define ADMXRC4_REF_OSC_FREQUENCY (25000000U)

#endif
