/*
** File: adb3.h  
** Project: ADB3 core driver
** Purpose: Definitions for ADB3 PCI to Local Bus Bridge.
**
** (C) Copyright Alpha Data 2009-2010
*/

#ifndef _ADATA_CORE_ADB3_H
#define _ADATA_CORE_ADB3_H

#include <df.h>

#define ADB3_NUM_DMA_CHANNEL (4)

/* An ADB3 DMA descriptor */
#pragma pack(1)
typedef struct _Adb3DmaDescriptor {
  uint32_t pal;
  uint32_t pah;
  uint32_t sizl;
  uint32_t sizh;
  uint32_t ndl;
  uint32_t ndh;
  uint32_t lal;
  uint32_t ctl;
} Adb3DmaDescriptor;
#pragma pack()

/* Fields in Adb3DmaDescriptor::ctl */
#define ADB3DMACTL_PCI_TO_LOCAL	          (0x1U << 16)
#define ADB3DMACTL_LOCAL_TO_PCI	          (0x0U << 16)
#define ADB3DMACTL_ENDCHAIN	              (0x1U << 17)
#define ADB3DMACTL_IRQ_ON_HOST_COMPLETION	(0x1U << 18)
#define ADB3DMACTL_IRQ_ON_FPGA_COMPLETION	(0x1U << 19)
#define ADB3DMACTL_IRQ_ON_DESC_READ	      (0x1U << 20)
#define ADB3DMACTL_WAIT_IRQ_ACK           (0x1U << 21)
#define ADB3DMACTL_FIXED_LOCAL_ADDR       (0x1U << 22)

#pragma pack(1)
typedef struct _Adb3DmaRegs {
  union {                     /* 0x00 */
    uint32_t abort;
    uint32_t status;
  } control;
  union {                     /* 0x04 */
    uint32_t cleanup;
    uint32_t fifoStatus;
  } cleanup;
  union {                     /* 0x08 */
    uint32_t ack;
    uint32_t status;
  } irq;
  uint32_t irqEnable;         /* 0x0C */
  uint32_t nextAddrLow;       /* 0x10 */
  uint32_t nextAddrHigh;      /* 0x14 */
  uint32_t hostControl;       /* 0x18 */
  uint32_t fpgaControl;       /* 0x1C */
  uint32_t alignment;         /* 0x20 */
  uint32_t descPause;         /* 0x24 */
  uint32_t _reserved1[6];     /* 0x28 */
} Adb3DmaRegs; /* total 0x40 bytes */
#pragma pack()

#define ADB3DMASTATUS_IDLE_MASK  (0xFFFU)
#define ADB3DMASTATUS_IDLE_VALUE (0xFFFU)

/* Flags in Adb3DmaRegs::alignment */
#define ADB3DMAALIGN_LOCAL_IGNORE_FIRST_WORD (0x10U)
#define ADB3DMAALIGN_LOCAL_USE_FIRST_WORD    (0x0U)

/* Flags in Adb3DmaRegs::irqEnable, Adb3DmaRegs::irqStatus */
#define ADB3DMAIRQ_PCIE_WRITE_WORKER_COMPLETED  (0x1U << 2)
#define ADB3DMAIRQ_MPTL_WRITE_WORKER_COMPLETED  (0x1U << 3)
#define ADB3DMAIRQ_PCIE_READ_WORKER_COMPLETED   (0x1U << 4)
#define ADB3DMAIRQ_MPTL_READ_WORKER_COMPLETED   (0x1U << 5)
#define ADB3DMAIRQ_ABORT                        (0x1U << 7)

#pragma pack(1)
typedef struct _Adb3GenericRegs {
  uint32_t irqStatus;         /* 0x000 */
  uint32_t irqEnable;         /* 0x004 */
  uint32_t dmaEnable;         /* 0x008 */
  uint32_t feature;           /* 0x00C */
  uint32_t pcieMisc;          /* 0x010 */
  uint32_t pcieControl;       /* 0x014 */
  uint32_t pcieStatus;        /* 0x018 */
  uint32_t fpgaMask;          /* 0x01C */
  uint32_t fpgaPageLow;       /* 0x020 */
  uint32_t fpgaPageHigh;      /* 0x024 */
  uint32_t fpga2Mask;         /* 0x028 */
  uint32_t fpga2PageLow;      /* 0x02C */
  uint32_t fpga2PageHigh;     /* 0x030 */
  uint32_t pcieBrgStatus;     /* 0x034 */
  uint32_t _reserved2[2];     /* 0x038 */
  Adb3DmaRegs dmaEngine[4];   /* 0x040 */
  uint8_t _reserved3[0xEC0U]; /* 0x140 */
} Adb3GenericRegs; /* total 0x1000 bytes */
#pragma pack()

/* Feature register */
#define ADB3FEAT_MSIFIX  (0x1U << 0) /* 1 => MSI bug fixed */
#define ADB3FEAT_ICAP_IF (0x1U << 5) /* 1 => Has ICAP interface in model-specific registers */

/* Flags in Adb3DmaRegs::irqStatus, Adb3DmaRegs::irqEnable */
#define ADB3IRQ_MODEL   (0x1U << 1)
#define ADB3IRQ_DMA0    (0x1U << 2)
#define ADB3IRQ_DMA1    (0x1U << 3)
#define ADB3IRQ_DMA2    (0x1U << 4)
#define ADB3IRQ_DMA3    (0x1U << 5)
#define ADB3IRQ_DMA_ALL (ADB3IRQ_DMA0 | ADB3IRQ_DMA1 | ADB3IRQ_DMA2 | ADB3IRQ_DMA3)

/* Flags in Adb3DmaRegs::dmaEnable */
#define ADB3DMAEN_LOCAL_MASTER (0x1U << 0)
#define ADB3DMAEN_DMA0         (0x1U << 1)
#define ADB3DMAEN_DMA1         (0x1U << 2)
#define ADB3DMAEN_DMA2         (0x1U << 3)
#define ADB3DMAEN_DMA3         (0x1U << 4)
#define ADB3DMAEN_DMA_ALL      (ADB3DMAEN_DMA0 | ADB3DMAEN_DMA1 | ADB3DMAEN_DMA2 | ADB3DMAEN_DMA3)

#endif
