/*
** File: adb1v4v5_common.h  
** Project: ADB1 core driver
** Purpose: Definitions for ADB1 common routines for V4 & V5 models.
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_ADB1V4V5_COMMON_H
#define _ADATA_CORE_ADB1V4V5_COMMON_H

#include "device.h"
#include "adb1.h"

extern void
adb1V4V5Flash(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int bankIndex,
  boolean_t bWrite,
  uint64_t location,
  uint32_t* pValue);

extern void
adb1V4V5FlashReset(
  Adb3CoreDeviceContext* pDevCtx);

extern FpgaControlStatus
adb1V4V5FpgaControl(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index,
  CoreFpgaControlOp opCode,
  uint32_t* pFpctlShadow,
  boolean_t* pbValue);

extern FpgaSelectMapStatus
adb1V4V5FpgaSelectMap(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index,
  boolean_t bWrite,
  size_t length,
  void* pBuffer);

extern boolean_t
adb1V4V5HandleInterrupt(
  Adb3CoreDeviceContext* pDevCtx,
  uint32_t gmask,  /* Bitmask of enabled generic interrupts */
  uint32_t mmask); /* Bitmask of model-specific interrupts */

extern boolean_t
adb1V4V5MapBusResources(
  Adb3CoreDeviceContext* pDevCtx,
  DfBusResources* pRaw,
  DfBusResources* pTranslated,
  boolean_t bUnmap);

extern boolean_t
adb1V4V5ValidateBusResources(
  Adb3CoreDeviceContext* pDevCtx,
  DfBusResources* pRaw,
  DfBusResources* pTranslated);

extern CoreVpdStatus
adb1V4V5ReadWriteVpd(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bWrite,
  size_t address,
  size_t length,
  void* pData);

extern CoreVpdStatus
adb1V4V5SyncVpd(
	Adb3CoreDeviceContext* pDevCtx);

#endif
