#if !defined(_ADATA_ADMXRC2_IOCTL_ADMXRC2_H)
#define _ADATA_ADMXRC2_IOCTL_ADMXRC2_H

/*
** File: ioctl_admxrc2.h  
** Project: ADMXRC2 API module library
** Purpose: Defines the IOCTL codes and structures for the ADMXRC2 API
**
** (C) Copyright Alpha Data 2013
**
** This file expects the following definitions to exist in the namespace:
**
**   ADMXRC2_HAS_USER_EVENT_HANDLE    - 0 or 1
**   ADMXRC2_NEED_THUNK               - if building for a platform where thunking to 32 bits is required (e.g. x86_64)
**   admxrc2_user_event_handle_t      - if ADMXRC2_HAS_USER_EVENT_HANDLE is 1
**   admxrc2_user_event_handle_t_32   - if ADMXRC2_HAS_USER_EVENT_HANDLE is 1 and ADMXRC2_NEED_THUNK is defined
**
** Use of ADMXRC2_PACKED_STRUCT is to work around a structure packing/sizeof
** issue that occurs with certain versions of gcc, including (at least)
** gcc-4.1.2. When compiling with gcc, this macro equates to
** __attribute__((packed)). Consequently, any modifications to the IOCTL
** structures below MUST NOT introduce members that are unaligned to their
** own size; otherwise, unaligned access exceptions may occur on some
** architectures when the driver executes an IOCTL handler.
*/

#if defined(__GNUC__)
# define ADMXRC2_PACKED_STRUCT __attribute__((packed))
#else
# define ADMXRC2_PACKED_STRUCT /* Nothing */
#endif

typedef enum _ADMXRC2_IOCTLCODE {
  ADMXRC2_IOCTLCODE_CONFIGURE = 1,
  ADMXRC2_IOCTLCODE_GETBANKINFO,
  ADMXRC2_IOCTLCODE_GETCARDINFO,
  ADMXRC2_IOCTLCODE_GETCLOCKFREQUENCY,
  ADMXRC2_IOCTLCODE_GETDRIVERVERSION,
  ADMXRC2_IOCTLCODE_GETSPACECONFIG,
  ADMXRC2_IOCTLCODE_GETSPACEINFO,
  ADMXRC2_IOCTLCODE_SETCLOCKFREQUENCY,
  ADMXRC2_IOCTLCODE_SETSPACECONFIG,
  ADMXRC2_IOCTLCODE_UNCONFIGURE,
  ADMXRC2_IOCTLCODE_REGISTEREVENT,
  ADMXRC2_IOCTLCODE_UNREGISTEREVENT,
  ADMXRC2_IOCTLCODE_READ,
  ADMXRC2_IOCTLCODE_WRITE,
  ADMXRC2_IOCTLCODE_LOCK,
  ADMXRC2_IOCTLCODE_UNLOCK,
  ADMXRC2_IOCTLCODE_DODMA,
  ADMXRC2_IOCTLCODE_DODMAIMMEDIATE,
  ADMXRC2_IOCTLCODE_CONFIGUREDMA,
  ADMXRC2_IOCTLCODE_READCONFIG,
  ADMXRC2_IOCTLCODE_WRITECONFIG,
  ADMXRC2_IOCTLCODE_ERASEFLASH,
  ADMXRC2_IOCTLCODE_GETFLASHINFO,
  ADMXRC2_IOCTLCODE_GETFLASHBLOCKINFO,
  ADMXRC2_IOCTLCODE_READFLASH,
  ADMXRC2_IOCTLCODE_SYNCFLASH,
  ADMXRC2_IOCTLCODE_WRITEFLASH,
  ADMXRC2_IOCTLCODE_GETFPGAINFO,
  ADMXRC2_IOCTLCODE_CANCELWAITFORINTERRUPT,
  ADMXRC2_IOCTLCODE_WAITFORINTERRUPT,
  ADMXRC2_IOCTLCODE_SETCOOPLEVEL,
  ADMXRC2_IOCTLCODE_GETSENSORINFO,
  ADMXRC2_IOCTLCODE_READSENSOR,
  ADMXRC2_IOCTLCODE_GETCOMMONBUFFERINFO,
  ADMXRC2_IOCTLCODE_SYNCCOMMONBUFFER,
  /* Debug Timestamping extension */
  ADMXRC2_IOCTLCODE_GETDEBUGTSINFO,
  ADMXRC2_IOCTLCODE_GETDEBUGTSSTATUS,
  ADMXRC2_IOCTLCODE_READDEBUGTS,
  ADMXRC2_IOCTLCODE_RESETDEBUGTS
} ADMXRC2_IOCTLCODE;

#define ADMXRC2_EVENT_FPGAINTERRUPT(targetIndex) ((targetIndex) | 0x100) /* Target FPGA interrupt */
#define ADMXRC2_EVENT_FPGAALERT(targetIndex)     ((targetIndex) | 0x200) /* Target FPGA overtemperature; reconfiguration pending */

#define ADMXRC2_REGION_TAG_MASK         (0xF0000000U)
#define ADMXRC2_REGION_TAG_MASKINV      (0x0FFFFFFFU)
#define ADMXRC2_REGION_TAG_WINDOW       (0x00000000U)
#define ADMXRC2_REGION_TAG_COMMONBUFFER (0x10000000U)

#define ADMXRC2_DMAFLAG_TIMEOUT (0x1U << 7)

#define ADMXRC2_INTWAIT_TIMEOUT (0x1U << 31)

#define ADMXRC2_FLASHFLAG_SYNC (0x1U << 0)

typedef union _IOCTLS_ADMXRC2_CANCELWAITFORINTERRUPT {
  struct {
    uint32_t targetIndex;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_CANCELWAITFORINTERRUPT;

typedef union _IOCTLS_ADMXRC2_CONFIGURE {
  struct {
    uint32_t targetIndex;
    uint32_t flags;
    const void* pBuffer;
    size_t length;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_CONFIGURE;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_CONFIGURE {
  struct {
    uint32_t targetIndex;
    uint32_t flags;
    const_ptr32_t pBuffer;
    size32_t length;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_CONFIGURE;
#endif

typedef union _IOCTLS_ADMXRC2_CONFIGUREDMA {
  struct {
    uint32_t targetIndex;
    uint32_t flags;
    const void* pBuffer;
    size_t length;
    uint32_t dmaChannel;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_CONFIGUREDMA;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_CONFIGUREDMA {
  struct {
    uint32_t targetIndex;
    uint32_t flags;
    const_ptr32_t pBuffer;
    size32_t length;
    uint32_t dmaChannel;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_CONFIGUREDMA;
#endif

typedef union _IOCTLS_ADMXRC2_DODMA {
  struct {
    uint64_t timeoutUs;
    size_t offset;
    size_t length;
    uint32_t local;
    uint32_t hDmaDesc;
    uint32_t channel;
    uint32_t mode;
    uint32_t dirFlags; /* Direction & flags */
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t timeoutUs;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_DODMA;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_DODMA {
  struct {
    uint64_t timeoutUs;
    size32_t offset;
    size32_t length;
    uint32_t local;
    uint32_t hDmaDesc;
    uint32_t channel;
    uint32_t mode;
    uint32_t dirFlags; /* Direction & flags */
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t timeoutUs;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS32_ADMXRC2_DODMA;
#endif

typedef union _IOCTLS_ADMXRC2_DODMAIMMEDIATE {
  struct {
    uint64_t timeoutUs;
    void* pBuffer;
    size_t length;
    uint32_t local;
    uint32_t channel;
    uint32_t mode;
    uint32_t dirFlags; /* Direction & flags */
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t timeoutUs;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_DODMAIMMEDIATE;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_DODMAIMMEDIATE {
  struct {
    uint64_t timeoutUs;
    ptr32_t pBuffer;
    size32_t length;
    uint32_t local;
    uint32_t channel;
    uint32_t mode;
    uint32_t dirFlags; /* Direction & flags */
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t timeoutUs;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS32_ADMXRC2_DODMAIMMEDIATE;
#endif

typedef union _IOCTLS_ADMXRC2_ERASEFLASH {
	struct {
		uint32_t flashIndex;
    uint32_t flags;
    uint32_t offset;
    uint32_t length;
	} ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_ERASEFLASH;

typedef union _IOCTLS_ADMXRC2_GETBANKINFO {
	struct {
		uint32_t index;
	} ADMXRC2_PACKED_STRUCT in;
  struct {
    uint32_t  typeMask;
    uint32_t  width;
    uint32_t  sizeWords;
    uint32_t  bFitted;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETBANKINFO;

typedef union _IOCTLS_ADMXRC2_GETCARDINFO {
  struct {
    uint32_t cardId;
    uint32_t serialNumber;
    uint32_t boardType;
    uint32_t fpgaType;
    uint32_t numClock;
    uint32_t numDmaChannel;
    uint32_t numMemoryBank;
    uint32_t numSpace;
    uint32_t numSensor;
    uint32_t numTargetFpga;
    uint32_t memoryBankFitted;
    uint8_t  boardRevision;
    uint8_t  logicRevision;
    uint16_t _reserved1;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETCARDINFO;

typedef union _IOCTLS_ADMXRC2_GETCLOCKFREQUENCY {
  struct {
    uint32_t clockIndex;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t frequency;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETCLOCKFREQUENCY;

typedef union _IOCTLS_ADMXRC2_GETCOMMONBUFFERINFO {
	struct {
		uint32_t index;
	} ADMXRC2_PACKED_STRUCT in;
	struct {
		uint64_t busAddress;
		size_t busSize;
	} ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETCOMMONBUFFERINFO;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_GETCOMMONBUFFERINFO {
	struct {
		uint32_t index;
	} ADMXRC2_PACKED_STRUCT in;
	struct {
		uint64_t busAddress;
		size32_t busSize;
	} ADMXRC2_PACKED_STRUCT out;
} IOCTLS32_ADMXRC2_GETCOMMONBUFFERINFO;
#endif

typedef union _IOCTLS_ADMXRC2_GETDEBUGTSINFO {
  struct {
    uint32_t facility;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t frequency;
    uint64_t initTimestamp;
    uint64_t initTime;
    size_t bufferSize;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETDEBUGTSINFO;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_GETDEBUGTSINFO {
  struct {
    uint32_t facility;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t frequency;
    uint64_t initTimestamp;
    uint64_t initTime;
    size32_t bufferSize;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS32_ADMXRC2_GETDEBUGTSINFO;
#endif

typedef union _IOCTLS_ADMXRC2_GETDEBUGTSSTATUS {
  struct {
    uint32_t facility;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    size_t count;
    uint32_t status;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETDEBUGTSSTATUS;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_GETDEBUGTSSTATUS {
  struct {
    uint32_t facility;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    size32_t count;
    uint32_t status;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS32_ADMXRC2_GETDEBUGTSSTATUS;
#endif

typedef union _IOCTLS_ADMXRC2_GETDRIVERVERSION {
  struct {
    uint32_t major;
    uint32_t minor;
    uint32_t bugfix;
    uint32_t build;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETDRIVERVERSION;

typedef union _IOCTLS_ADMXRC2_GETFLASHBLOCKINFO {
  struct {
    uint32_t flashIndex;
    uint32_t location;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint32_t flags;
    uint32_t start;
    uint32_t length;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETFLASHBLOCKINFO;

typedef union _IOCTLS_ADMXRC2_GETFLASHINFO {
  struct {
    uint32_t flashIndex;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint32_t deviceSize;
    uint32_t deviceBlockSize;
    uint32_t useableStart;
    uint32_t useableLength;
    uint16_t vendorId;
    uint16_t deviceId;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETFLASHINFO;

typedef union _IOCTLS_ADMXRC2_GETFPGAINFO {
  struct {
    uint32_t index;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    char package[12];
    uint32_t type;
    int32_t speed;
    int32_t stepping;
    int32_t tempGrade;
    int32_t scd;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETFPGAINFO;

typedef union _IOCTLS_ADMXRC2_GETSENSORINFO {
  struct {
    uint32_t sensorIndex;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    char description[28];
    uint32_t capabilities;
    struct {
      int16_t intPart;
      uint16_t fracPart;
    } error;
    uint32_t datatype;
    uint32_t unit;
    int32_t exponent;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETSENSORINFO;

typedef union _IOCTLS_ADMXRC2_GETSPACECONFIG {
	struct {
		uint32_t index;
	} ADMXRC2_PACKED_STRUCT in;
  struct {
    uint32_t configFlags;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETSPACECONFIG;

typedef union _IOCTLS_ADMXRC2_GETSPACEINFO {
	struct {
		uint32_t index;
	} ADMXRC2_PACKED_STRUCT in;
	struct {
		uint64_t virtualSize;
		uint64_t busBase;
		uint64_t busSize;
		uint64_t localBase;
		uint64_t localSize;
	} ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_GETSPACEINFO;

typedef union _IOCTLS_ADMXRC2_LOCK {
  struct {
    const void* pBuffer;
    size_t length;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint32_t hBuffer;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_LOCK;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_LOCK {
  struct {
    ptr32_t pBuffer;
    size32_t length;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint32_t hBuffer;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS32_ADMXRC2_LOCK;
#endif

typedef union _IOCTLS_ADMXRC2_READ {
  struct {
    uint32_t width;
    uint32_t flags;
    uint32_t local;
    void* pBuffer;
    size_t length;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_READ;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_READ {
  struct {
    uint32_t width;
    uint32_t flags;
    uint32_t local;
    ptr32_t pBuffer;
    size32_t length;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_READ;
#endif

typedef union _IOCTLS_ADMXRC2_READCONFIG {
  struct {
    uint32_t index;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint32_t value;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_READCONFIG;

typedef union _IOCTLS_ADMXRC2_READFLASH {
	struct {
		uint32_t flashIndex;
    uint32_t flags;
    uint32_t offset;
    uint32_t length;
    void* pBuffer;
	} ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_READFLASH;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_READFLASH {
	struct {
		uint32_t flashIndex;
    uint32_t flags;
    uint32_t offset;
    uint32_t length;
    ptr32_t pBuffer;
	} ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_READFLASH;
#endif

typedef union _IOCTLS_ADMXRC2_READSENSOR {
  struct {
    uint32_t sensorIndex;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    union {
      struct {
        int32_t intPart;
        uint32_t fracPart;
      } doubleValue;
      uint32_t booleanValue;
      uint32_t uint32Value;
      int32_t int32Value;
    } value;
    uint32_t datatype;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_READSENSOR;

typedef union _IOCTLS_ADMXRC2_READDEBUGTS {
  struct {
    uint32_t facility;
    size_t offset;
    size_t count;
    uint32_t flags;
    void* pBuffer;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_READDEBUGTS;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_READDEBUGTS {
  struct {
    uint32_t facility;
    size32_t offset;
    size32_t count;
    uint32_t flags;
    ptr32_t pBuffer;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_READDEBUGTS;
#endif

#if ADMXRC2_HAS_USER_EVENT_HANDLE
typedef union _IOCTLS_ADMXRC2_REGISTEREVENT {
  struct {
    admxrc2_user_event_handle_t hEvent;
    uint32_t notification;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_REGISTEREVENT;

# if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_REGISTEREVENT {
  struct {
    admxrc2_user_event_handle_t_32 hEvent;
    uint32_t notification;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_REGISTEREVENT;
# endif
#endif

typedef union _IOCTLS_ADMXRC2_RESETDEBUGTS {
  struct {
    uint32_t facility;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_RESETDEBUGTS;

typedef union _IOCTLS_ADMXRC2_SETCLOCKFREQUENCY {
  struct {
    uint32_t clockIndex;
    uint32_t flags;
    uint64_t frequency;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t actualFrequency;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_SETCLOCKFREQUENCY;

typedef union _IOCTLS_ADMXRC2_SETCOOPLEVEL {
	struct {
		uint32_t coopLevel;
	} ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_SETCOOPLEVEL;

typedef union _IOCTLS_ADMXRC2_SETSPACECONFIG {
	struct {
		uint32_t index;
    uint32_t configFlags;
	} ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_SETSPACECONFIG;

typedef union _IOCTLS_ADMXRC2_SYNCCOMMONBUFFER {
  struct {
    uint32_t index;
    uint32_t syncMode;
    size_t offset;
    size_t length;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_SYNCCOMMONBUFFER;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_SYNCCOMMONBUFFER {
  struct {
    uint32_t index;
    uint32_t syncMode;
    size32_t offset;
    size32_t length;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_SYNCCOMMONBUFFER;
#endif

typedef union _IOCTLS_ADMXRC2_SYNCFLASH {
  struct {
    uint32_t flashIndex;
    uint32_t flags;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_SYNCFLASH;

typedef union _IOCTLS_ADMXRC2_UNCONFIGURE {
  struct {
    uint32_t targetIndex;
    uint32_t flags;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_UNCONFIGURE;

typedef union _IOCTLS_ADMXRC2_UNLOCK {
  struct {
    uint32_t hBuffer;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_UNLOCK;

#if ADMXRC2_HAS_USER_EVENT_HANDLE
typedef union _IOCTLS_ADMXRC2_UNREGISTEREVENT {
  struct {
    admxrc2_user_event_handle_t hEvent;
    uint32_t notification;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_UNREGISTEREVENT;

# if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_UNREGISTEREVENT {
  struct {
    admxrc2_user_event_handle_t_32 hEvent;
    uint32_t notification;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_UNREGISTEREVENT;
# endif
#endif

typedef union _IOCTLS_ADMXRC2_WAITFORINTERRUPT {
  struct {
    uint64_t timeoutUs;
    uint32_t targetIndex;
    uint32_t flags;
  } ADMXRC2_PACKED_STRUCT in;
  struct {
    uint64_t timeoutUs;
  } ADMXRC2_PACKED_STRUCT out;
} IOCTLS_ADMXRC2_WAITFORINTERRUPT;

typedef union _IOCTLS_ADMXRC2_WRITE {
  struct {
    uint32_t width;
    uint32_t flags;
    uint32_t local;
    const void* pData;
    size_t length;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_WRITE;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_WRITE {
  struct {
    uint32_t width;
    uint32_t flags;
    uint32_t local;
    const_ptr32_t pData;
    size32_t length;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_WRITE;
#endif

typedef union _IOCTLS_ADMXRC2_WRITECONFIG {
  struct {
    uint32_t index;
    uint32_t value;
  } ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_WRITECONFIG;

typedef union _IOCTLS_ADMXRC2_WRITEFLASH {
	struct {
		uint32_t flashIndex;
    uint32_t flags;
    uint32_t offset;
    uint32_t length;
    const void* pData;
	} ADMXRC2_PACKED_STRUCT in;
} IOCTLS_ADMXRC2_WRITEFLASH;

#if defined(ADMXRC2_NEED_THUNK)
typedef union _IOCTLS32_ADMXRC2_WRITEFLASH {
	struct {
		uint32_t flashIndex;
    uint32_t flags;
    uint32_t offset;
    uint32_t length;
    const_ptr32_t pData;
	} ADMXRC2_PACKED_STRUCT in;
} IOCTLS32_ADMXRC2_WRITEFLASH;
#endif

#endif
