#!/bin/bash
#
# This is a helper script that figures out where to install a 32-bit shared
# library in a bi-architecture capable 64-bit system, and then installs it
# and creates the usual additional symbolic links.
#
# /usr/local is preferred over /usr/ .
#
# lib32_install_helper <name.so.x.y.z> <name.so.x> <name.so> <system root>
#
# <name.so.x.y.z>, <name.so.x> & <name.so> must be supplied.
# <system root> may be omitted.
#

SO_XYZ=$1
SO_X=$2
SO=$3
SYSROOT=$4

USRLIB=$SYSROOT/usr/lib
USRLOCALLIB=$SYSROOT/usr/local/lib

# Set this to 1 if shared libraries should be installed under /usr/local/lib (if possible),
# falling back to /usr/lib if not possible.
PREFER_USRLOCAL=0

if [ "$PREFER_USRLOCAL" == "1" ] && [ -d "${USRLOCALLIB}64" ] && [ -d "${USRLOCALLIB}32" ] ; then
    # x64 Gentoo-style layout:
    #   Native libs -> $SYSROOT/usr/lib64 (and there may exist a symlink lib -> lib64)
    #   32-bit libs -> $SYSROOT/usr/lib32
    #INSTALL_PATH="${USRLOCALLIB}64"
    INSTALL_PATH32="${USRLOCALLIB}32"
elif [ "$PREFER_USRLOCAL" == "1" ] && [ -d "${USRLOCALLIB}64" ] && [ -d "${USRLOCALLIB}" ] ; then
    # x64 Fedora/RedHat-style layout:
    #   Native libs -> $SYSROOT/usr/lib64
    #   32-bit libs -> $SYSROOT/usr/lib
    #INSTALL_PATH="${USRLOCALLIB}64"
    INSTALL_PATH32="${USRLOCALLIB}"
elif [ "$PREFER_USRLOCAL" == "1" ] && [ -d "${USRLOCALLIB}" ] && [ -d "${USRLOCALLIB}32" ] ; then
    # x64 Ubuntu-style layout:
    #   Native libs -> $SYSROOT/usr/lib
    #   32-bit libs -> $SYSROOT/usr/lib32
    #INSTALL_PATH="${USRLOCALLIB}"
    INSTALL_PATH32="${USRLOCALLIB}32"
else
    if [ -d "${USRLIB}64" ] && [ -d "${USRLIB}32" ] ; then
        # x64 Gentoo-style layout:
        #   Native libs -> $SYSROOT/usr/lib64 (and there may exist a symlink lib -> lib64)
        #   32-bit libs -> $SYSROOT/usr/lib32
        #INSTALL_PATH="${USRLIB}64"
        INSTALL_PATH32="${USRLIB}32"
    elif [ -d "${USRLIB}64" ] && [ -d "${USRLIB}" ] ; then
        # x64 Fedora/RedHat-style layout:
        #   Native libs -> $SYSROOT/usr/lib64
        #   32-bit libs -> $SYSROOT/usr/lib
        #INSTALL_PATH="${USRLIB}64"
        INSTALL_PATH32="${USRLIB}"
    elif [ -d "${USRLIB}" ] && [ -d "${USRLIB}32" ] ; then
        # x64 Ubuntu-style layout:
        #   Native libs -> $SYSROOT/usr/lib
        #   32-bit libs -> $SYSROOT/usr/lib32
        #INSTALL_PATH="${USRLIB}"
        INSTALL_PATH32="${USRLIB}32"
    else
        echo "*** Cannot determine path of shared library directory for 32-bit libraries."
        echo "    Please try '-biarch no' instead."
        exit 1
    fi;
fi;

install -m 755 $SO_XYZ $INSTALL_PATH32
echo "Installed $SO_XYZ in $INSTALL_PATH32"
ldconfig -n $INSTALL_PATH32
(cd $INSTALL_PATH32 && ln -sf $INSTALL_PATH32/$SO_X $SO)
