/*
* Title:	tmsSink.h
* Author:	M.Thomas Beam Ltd
* Date:		2007-03-15
* Contents:	Datasinking class for stress testing
*
*/

#ifndef TMSSINK_H
#define TMSSINK_H

#include <BThread.h>
#include <TmsC.h>
#include <BTimer.h>
#include <BMutex.h>

using namespace Tms;


class TmsSinkStats {
	public:
		TmsSinkStats() {};
	public:
		double 	bytesPerCycle;	///< Max bytes per cycle bofore a sleep
		double	transferRate;	///< Returns MBytes/sec of transfer rate
		double	packets;	///< Returns the number of packets read
		double	bytes;		///< Bytes read
		double	duration;	///< Elapsed duration
		double	overRuns;	///< Times that data has been overwritten in the server


		double	deltaRate;	///< Transfer Rate MBytes/s since last request for data
		double	deltaBytes;	///< Bytes since last request for data
		double	deltaPackets;	///< Packets since last request for data
		double	deltaOverRuns;	///< Packets since last request for data

		DataInfo dataInfo;
	};


class	TmsSink : public BThread {
public:
	TmsSink(BString host ="",int id = 0);
	~TmsSink();
	
	BError	getLastError();
	
	
	// Access via External thread
	BError		connect();
	void		startTimer();
	void		setRate(double megPerSecond);		///< Requested data rate
	void		setupRequest(DataInfo odataInfo); 	///< Setup capture parameters Cycle number is autogenerated
	TmsSinkStats	getStats();				///< Get statistics
	
	void*		function();			///< Thread startup method
	int		oid;

private:
	void	addError(BError err);			///< Add Error to list of errors
	BError	setupRequest();
	BError 	getData();
	BError	saveToFile();				///< Save latest packet to file


	BMutex		olock;

	BString		ohost;
	TmsProcess	oprocess;

	double		obytesPerCycle;			///< Max byte read before sleep

	
	DataInfo	odataInfo;
	Data		odata;

	// Accessed by start thread only
	TmsSinkStats	oprior;				
	BTimer		otimer;	


	double		opacketsRead;
	double		obytesRead;
	double		orate;
	double		ooverRuns;	
	
	BList<BError>	oerr;

};

#endif
