/*
* Title:	TmsStateMainWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	The main test Gui window
*
* Mod Rec:
*
*/

#ifndef	TmsStateMainWin_H
#define TmsStateMainWin_H	1


#include <AppGui.h>
#include <BError.h>
#include <BString.h>
#include <TmsCycleParam.h>
#include <BGraph.h>
#include <qtabwidget.h>
#include <qspinbox.h>
#include <qtextview.h>
#include <qlineedit.h>

class TmsStateMainWin: public AppGui {
	Q_OBJECT
public:
	TmsStateMainWin();
	~TmsStateMainWin();

	void	warningDialog(BString title,BError err,BString msg = "");	///< Warning dialog
public slots:
	void	slotQuit();				///< Exit the application

private slots:
	void	slotEnterWhatsThis();			///< Enter Whats This mode
	void	slotAbout();				///< Display the About dialog
	void	slotManual();				///< Display the online manual
	void	slotTmsManual();			///< Didplay Tms System Manual index
	void	slotUpdate();
private:
	void	initMenubar();				///< Initialize menu bar
	void	initMain();				///< Initialize main widget
	void	initToolbar();				///< Initialize main widget

	QTabWidget*		otabd;			///< Tab widget controlling other widget panes
	QSpinBox*		ostate;
	QLineEdit*		ostateInfo;
	QLineEdit*		ostateField0;
	QLineEdit*		ostateField1;

	Tms::CycleParamEdit	ocycleParam;
	BArray<BGraph*>		ographs;
};
#endif
