/*
* Title:	tmsControlMainGui.cpp 
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Primary interface for Cern TMS system test/debug Gui
*
* Mod Rec:
*
*/

#include <qmenubar.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qinputdialog.h>
#include <qimage.h>

#include <TmsStateMainWin.h>
#include <BFile.h>
#include <unistd.h>
#include <math.h>
#include <main.h>

const int	nGraphs = 7;

TmsStateMainWin::TmsStateMainWin(){
}

TmsStateMainWin::~TmsStateMainWin(){
}

void TmsStateMainWin::initMenubar(){
	QPopupMenu*	m;
	QAction*	a;
	
	m = new QPopupMenu();
	a = addAction(m, tr("Quit"), tr("&Quit"), tr("Ctrl+Q"), SLOT(slotQuit()), tr("Quits the application"));
	menuBar()->insertItem(tr("&File"), m);

        menuBar( )->insertSeparator(-1);
	m = new QPopupMenu();
//	a = addAction(m, tr("Whats This"), tr("&Whats This"), tr("Ctrl+W"), SLOT(slotEnterWhatsThis()), tr("Enter Whats This mode"));
	a = addAction(m, tr("Manual"), tr("&Manual"), tr("Ctrl+M"), SLOT(slotManual()), tr("Online Manual"));
	a = addAction(m, tr("TMS Manual"), tr("&TMS Manual"), tr("Ctrl+T"), SLOT(slotTmsManual()), tr("TMS System Manual"));
	a = addAction(m, tr("About"), tr("&About"), tr("Ctrl+A"), SLOT(slotAbout()), tr("About the program"));
	menuBar()->insertItem(tr("&Help"), m);
//	setMinimumSize(QSize(1024,850));
}

void TmsStateMainWin::initMain(){
	BError		err;
	QFont		f;
	QStatusBar*	wstatusBar;
	BGraph*		graph;
	QVBox*		vbox;
	QHBox*		cbox;
	int		n;
	
	otabd     	= new QTabWidget(this);

	setCentralWidget(otabd);
	otabd->setName("Tab Widget");
	otabd->setMinimumSize(1000,860);
	otabd->setTabPosition(QTabWidget::Bottom);

	vbox = new QVBox(otabd);
	
	
	ographs.resize(nGraphs);
	for(n = 0; n < nGraphs; n++){
		graph = new BGraph(vbox);

		graph->setPlotType(BGraph::LINES);
		graph->setGrid(16,16);
		switch(n){
		case 0:	graph->setYLabel("FREF");	break;
		case 1:	graph->setYLabel("LO1");	break;
		case 2:	graph->setYLabel("LO2");	break;
		case 3:	graph->setYLabel("GATE");	break;
		case 4:	graph->setYLabel("BLR");	break;
		case 5:	graph->setYLabel("Mean1");	break;
		case 6:	graph->setYLabel("Mean2");	break;
		}
				
		ographs[n] = graph;
	}

	cbox = new QHBox(vbox);

	ostate = new QSpinBox(cbox);
	ostate->setMaxValue(15);
	ostate->setMinValue(0);

	ostateInfo = new QLineEdit(cbox);
	ostateField0 = new QLineEdit(vbox);
	ostateField1 = new QLineEdit(vbox);

	otabd->addTab(vbox, "Data View");
	otabd->show();

	f = qApp->font();
	f.setPointSize(10);
	qApp->setFont(f,true);
	
	wstatusBar = statusBar();
	
	slotUpdate();

	connect(ostate, SIGNAL(valueChanged(int)), this, SLOT(slotUpdate()));
}

void	TmsStateMainWin::slotUpdate(){
	int			state;
	int			s;
	BArray<float>		data[nGraphs];
	Tms::TmsPhase		p;
	Tms::TmsState		sf;
	int			n;
	BString			str;
	BFile			file("data.txt", "w");
	
	state = ostate->value();
	
	ocycleParam.readFromFile(fileName);
	
	str.printf("Period: %d Harmonic: %d NumBunches: %d BunchMask: 0x%x State: 0x%8.8x\n",
		ocycleParam.stateTable[state].period, ocycleParam.stateTable[state].harmonic,
		ocycleParam.stateTable[state].numBunches, ocycleParam.stateTable[state].bunchMask, ocycleParam.stateTable[state].state);

	ostateInfo->clear();
	ostateInfo->setText(str.retStr());

	sf.value = ocycleParam.stateTable[state].state;

	str.printf("Delay: %d HChange: %d Injection: %d CalStart: %d CalStop: %d CycleStop: %d",
		sf.delay, sf.hchange, sf.injection, sf.calStart, sf.calStop, sf.cycleStop); 

	ostateField0->clear();
	ostateField0->setText(str.retStr());
	
	str.printf("pllLO2FromAddress: %d, pllLO1FromAddress: %d, pllFeedbackSelect: %d, pllReference2: %d, pllReference1: %d, aquireData: %d",
		sf.pllLO2FromAddress, sf.pllLO1FromAddress, sf.pllFeedbackSelect, sf.pllReference2, sf.pllReference1, sf.aquireData); 

	ostateField1->clear();
	ostateField1->setText(str.retStr());
	
	for(n = 0; n < nGraphs; n++){
		data[n].resize(512);
	}
	
	for(s = 0; s < 512; s++){
		p.value = ocycleParam.stateTable[state].phaseTable[s];
		
		if(s < 256)
			data[0][s] = 1;
		if(p.lo1)
			data[1][s] = 1;
		if(p.lo2)
			data[2][s] = 1;
		if(p.gate)
			data[3][s] = 1;
		if(p.blr)
			data[4][s] = 1;
		if(p.meanFilter1)
			data[5][s] = 1;
		if(p.meanFilter2)
			data[6][s] = 1;
		
		file.printf("%f %f %f %f %f %f %f\n", data[0][s], data[1][s], data[2][s], data[3][s], data[4][s], data[5][s], data[6][s]); 
	}

	for(n = 0; n < nGraphs; n++){
		ographs[n]->setData(data[n]);
	}
}

void	TmsStateMainWin::slotQuit() {
	exit(0);
}

void	TmsStateMainWin::initToolbar() {
}


void	TmsStateMainWin::slotEnterWhatsThis() {
	whatsThis();
}

void	TmsStateMainWin::warningDialog(BString title,BError err,BString msg){
	BString	m;
	
	m = BString("<h5>") + title + "</h5><p>" + msg + "<br>" + err.getString() + "</p>";
	QMessageBox::warning(this, "tmsControlGui - Warning", m.retStr());
}

void TmsStateMainWin::slotAbout() {
	BString		msg;
	QImage		logo("alphadata_beam_logo.png");
	QMessageBox	mbox(this);
	
	
	msg = "<p><b>tmsControlGui</b> - Trajectory Measurement System Test Interface</p>";
	msg += BString("<p>&copy; BEAM Ltd 2007</p><p>Version: ") + VERSION + "</p>";

	mbox.setIconPixmap(logo);
	mbox.setCaption("About");
	mbox.setText(msg.retStr());
	mbox.exec();
}

void TmsStateMainWin::slotManual() {
	BIter		i;
	BList<BString>	fnames;
	BString		fname;
	BString		cmd;
	
	fnames.append("/usr/tms/doc/TmsControlGui.pdf");
	fnames.append("./TmsControlGui.pdf");
	fnames.append("../doc/TmsControlGui.pdf");
	fnames.append("../../doc/TmsControlGui.pdf");

	for (fnames.start(i);! fnames.isEnd(i); fnames.next(i)) {
		if (access(fnames[i].retStr(),R_OK) == 0) {
			fname = fnames[i];
			break;
		}	
	}
	if (! fnames.isEnd(i)) {
		cmd =BString("firefox ") + fname + "&";
		system(cmd.retStr());
	}
	else {
		QMessageBox::warning(this, "Warning", "Unable to locate the help files");
	}
}




void TmsStateMainWin::slotTmsManual() {
	BIter		i;
	BList<BString>	fnames;
	BString		fname;
	BString		cmd;
	
	fnames.append("/usr/tms/doc/index.html");
	fnames.append("./index.html");
	fnames.append("../doc/index.html");
	fnames.append("../../doc/index.html");

	for (fnames.start(i);! fnames.isEnd(i); fnames.next(i)) {
		if (access(fnames[i].retStr(),R_OK) == 0) {
			fname = fnames[i];
			break;
		}	
	}
	if (! fnames.isEnd(i)) {
		cmd =BString("firefox ") + fname + "&";
		system(cmd.retStr());
	}
	else {
		QMessageBox::warning(this, "Warning", "Unable to locate the help files");
	}
}





