/***************************************************************************
 *	TmsStateGui.cpp	TMS Cycle parameters State display
 *			T.Barnaby,	BEAM Ltd,	2007-11-13
 ***************************************************************************
 */
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qinputdialog.h>
#include <qimage.h>

#include <TmsStateGui.h>
#include <BFile.h>
#include <unistd.h>
#include <math.h>

const int	nGraphs = 7;

TmsStateGui::TmsStateGui(){
}

TmsStateGui::~TmsStateGui(){
}

void TmsStateGui::init(){
	BError		err;
	BGraph*		graph;
	QHBox*		cbox;
	int		n;
	
	ographs.resize(nGraphs);
	for(n = 0; n < nGraphs; n++){
		graph = new BGraph(this);

		graph->setPlotType(BGraph::LINES);
		graph->setGrid(16,16);
		switch(n){
		case 0:	graph->setYLabel("FREF");	break;
		case 1:	graph->setYLabel("LO1");	break;
		case 2:	graph->setYLabel("LO2");	break;
		case 3:	graph->setYLabel("GATE");	break;
		case 4:	graph->setYLabel("BLR");	break;
		case 5:	graph->setYLabel("Mean1");	break;
		case 6:	graph->setYLabel("Mean2");	break;
		}
				
		ographs[n] = graph;
	}

	cbox = new QHBox(this);

	ostate = new QSpinBox(cbox);
	ostate->setMaxValue(15);
	ostate->setMinValue(0);

	ostateInfo = new QLineEdit(cbox);
	ostateField0 = new QLineEdit(this);
	ostateField1 = new QLineEdit(this);

	connect(ostate, SIGNAL(valueChanged(int)), this, SLOT(slotUpdate()));
}

BError	TmsStateGui::slotView(Tms::CycleParamEdit& cycleParam){
	BError	err;
	
	ocycleParam = cycleParam;
	slotUpdate();
	
	return err;
}

void	TmsStateGui::slotUpdate(){
	int			state;
	int			s;
	BArray<float>		data[nGraphs];
	Tms::TmsPhase		p;
	Tms::TmsState		sf;
	int			n;
	BString			str;
	BFile			file("data.txt", "w");
	
	if(ocycleParam.cycleType == "")
		return;

	state = ostate->value();
	
	str.printf("Period: %d Harmonic: %d NumBunches: %d BunchMask: 0x%x State: 0x%8.8x\n",
		ocycleParam.stateTable[state].period, ocycleParam.stateTable[state].harmonic,
		ocycleParam.stateTable[state].numBunches, ocycleParam.stateTable[state].bunchMask, ocycleParam.stateTable[state].state);

	ostateInfo->clear();
	ostateInfo->setText(str.retStr());

	sf.value = ocycleParam.stateTable[state].state;

	str.printf("Delay: %d HChange: %d Injection: %d CalStart: %d CalStop: %d CycleStop: %d",
		sf.delay, sf.hchange, sf.injection, sf.calStart, sf.calStop, sf.cycleStop); 

	ostateField0->clear();
	ostateField0->setText(str.retStr());
	
	str.printf("pllLO2FromAddress: %d, pllLO1FromAddress: %d, pllFeedbackSelect: %d, pllReference2: %d, pllReference1: %d, aquireData: %d",
		sf.pllLO2FromAddress, sf.pllLO1FromAddress, sf.pllFeedbackSelect, sf.pllReference2, sf.pllReference1, sf.aquireData); 

	ostateField1->clear();
	ostateField1->setText(str.retStr());
	
	for(n = 0; n < nGraphs; n++){
		data[n].resize(512);
	}
	
	for(s = 0; s < 512; s++){
		p.value = ocycleParam.stateTable[state].phaseTable[s];
		
		if(s < 256)
			data[0][s] = 1;
		if(p.lo1)
			data[1][s] = 1;
		if(p.lo2)
			data[2][s] = 1;
		if(p.gate)
			data[3][s] = 1;
		if(p.blr)
			data[4][s] = 1;
		if(p.meanFilter1)
			data[5][s] = 1;
		if(p.meanFilter2)
			data[6][s] = 1;
		
		file.printf("%f %f %f %f %f %f %f\n", data[0][s], data[1][s], data[2][s], data[3][s], data[4][s], data[5][s], data[6][s]); 
	}

	for(n = 0; n < nGraphs; n++){
		ographs[n]->setData(data[n]);
	}
}
