/*******************************************************************************
 *	Gui.h		TapeSigGen Gui
 *			T.Barnaby,	BEAM Ltd,	2006-11-30
 *******************************************************************************
 */
#ifndef GUI_H
#define GUI_H	1

#include <qapplication.h>
#include <BError.h>
#include <BWidgets.h>
#include <AppGui.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qtextedit.h>

#include <SigGen.h>
#include <Tests.h>
#include <BThread.h>
#include <stdint.h>

class Gui;

class Gui: public AppGui, public BThread {
        Q_OBJECT
public:
	        Gui();
	        ~Gui();

	void	initMain();
	void	initMenubar();
	void	initToolbar();
	
public slots:
	void	manual();
	void	about();
	void	update();
	
	void	startTest();
	void	stopTest();
private:
	void*		function();
	QComboBox*	owtype;
	QLineEdit*	owsampleFreq;
	QLineEdit*	owsignalAmplitude;
	QTextEdit*	owinfo;
	QPushButton*	owstartButton;
	QPushButton*	owstopButton;
	
	// Signal Generator objects
	BList<Test*>&	otests;
	Test*		otest;
};
#endif
