function [sig] = genSine(sampleRate, numSamples, freq)
	sig = sin(2 * pi * freq / sampleRate * (0:(numSamples-1)));		% Simple sine
endfunction

function [r] = rms(signal)
	r = sqrt(mean(signal .* signal));
endfunction

# In Octave filter design the filter routines are given a cutoff value of 0-1. Where 1 = fs/2.
#
function [ rad ] = cutOff(freq, sampleRate)
	rad = (2 * freq) / sampleRate;
end


sampleRate		= 125000000 / 2;	% Sample Rate Hz
numSamples		= 10240;		% Number of samples length of test vector (1 sec realtime)

freqList = 1:10000:437000;
freqList = 1:10000:4370000;
rmsList = 1:length(freqList);

for f = 1:length(freqList)
	printf("%f\n", freqList(f));
	n1 = genSine(sampleRate, numSamples,  freqList(f));

	a = [1 1/256-1];
	b = [1 0 1/1024-1];

	n2 = filter(1,a,n1);
	n3 = filter(1,a,n2);
	n4 = filter(b,1,n3);
	n5 = filter(1,a,n4);
	n6 = filter(b,1,n5);
	
#	[bButter, aButter] = butter(2, cutOff(437000, sampleRate));
#	n6 = filter(bButter, aButter, n1);

	rmsList(f) = rms(n6);
endfor

sig = 20 * log10(rmsList);
maxdB = max(sig);
sig = sig - maxdB;

#plot(freqList, rmsList);
plot(freqList, sig);
input('Type to continue');
exit(1);

freqz(1, a);
input('Type to continue');

multiplot(1,2);
subwindow(1,1);
plot(n1);
subwindow(1,2);
plot(n6);
input('Type to continue');
