/*******************************************************************************
 *	Pll.cpp	Signal Pllerator classes
 *			T.Barnaby,	BEAM Ltd,	2006-09-12
 *******************************************************************************
 */

#include <Pll.h>
#include <BArray.h>
#include <math.h>


BString ParamList::getValue(BString name){
	BString*	s;
	
	if(s = find(name)){
		return *s;
	}
	return "";
}

void ParamList::setValue(BString name, BString value){
	BString*	s;
	
	if(s = find(name)){
		*s = value;
		return;
	}
	else {
		append(Param(name, value));
//		BList<PllParam>::append(PllParam(name, value));
	}
}

class Filter1 {
public:
		Filter1(){
			z0 = z1 = z2 = 0;
		}
		Int32	process(Int32 x){
			static double	a0 = 1.0, a1 = -1.991114292201654, a2 = 0.991153595868935;
			static double	b0 = 1.0, b1 = 2.0, b2 = 1.0;
			static double	g = 9.82592e-6;
			double		y;

			z0 = a0 * x - a1 * z1 - a2 * z2;
			y = z0 * b0+ z1 * b1 + z2 * b2;
			z2 = z1; 
			z1 = z0;

			return int(g * y);
		}
private:
		double	z0, z1, z2;
};

class Filter2 {
public:
		Filter2(){
			n1 = n2 = n3 = s4 = n4 = n5 = s6 = n6 = 0;
		}
	Int32	process(Int32 n1){
		n6 = n5 - s6;
		s6 = n5 - (n5 >> 10);
//		n5 = n4 + n5 - (n5 >> 8);	// FPGA
		n5 = n4 + n5 - (n5 >> 10);	// Matlab
		n4 = n3 - s4;
		s4 = n3 - (n3 >> 10);
		n3 = n2 + n3 - (n3 >> 8);
		n2 = n1 + n2 - (n2 >> 8);

//		return (n6 >> 7);
		return n6;
	}
private:
	Int32	n1;
	Int32	n2;
	Int32	n3;
	Int32	s4;
	Int32	n4;
	Int32	n5;
	Int32	s6;
	Int32	n6;
};

Pll::Pll(){
	osampleRate = 125000000.0;
	ofref = 437000.0;
}

Pll::~Pll(){
}

BError Pll::init(ParamList& params){
	BError		err;
	BString		s;
	TmsCycleParams	cycleParams("../datasrc");
	
	oparams = params;
	
	if((s = params.getValue("fileName")) != "")
		ofileName = s;

	if((s = params.getValue("sampleRate")) != "")
		osampleRate = atof(s);

	if((s = params.getValue("fref")) != "")
		ofref = atof(s);

	cycleParams.getCycleParams("Beam3_0.spt", ocycleParam);
	
	return err;
}


BError Pll::run(){
	BError		err;
	unsigned int	numSamples = 512;
	BArray<Sample>	sigma(numSamples);
	BArray<Sample>	fref(numSamples);
	SigGenBeam	sigGenBeam;
	SigGenSquare	sigGenFRef;
	unsigned int	l;
	unsigned int	s;
	int		state = 1;
	UInt32		pllFrequency = 30030411;
	UInt32		pllAddress = 0;
	Int32		pllError;
	Int32		lo0;
	Int32		mult0;
	Int32		pllError0;
	Int32		lo1;
	Int32		mult1;
	Int32		pllError1;
	TmsPhase	pte;
	BFile		file("data.txt", "w");

	Filter2		filter0;
	Filter2		filter1;
	Int32		pllSelect = 1;
	Int32		sigmaClip = 0;
//	double		pllGain = 1.0 / 32;
	double		pllGain = 1.0 / 8;
//	double		pllGain = 1.0 / 1;
	Int32		frefGain = 4096;
//	Int32		frefGain = 500;

//	pllFrequency += UInt32(pllFrequency * 0.02);
	
	sigGenBeam.config(osampleRate, ofref, 8, 0x3C, 0, 0, 4096.0);
	sigGenFRef.config(osampleRate, ofref, 1.0);

	for(l = 0; l < 100; l++){
		sigGenFRef.generate(fref.data(), numSamples);
		sigGenBeam.generate(sigma.data(), numSamples);
		
		for(s = 0; s < numSamples; s++){
			if(sigmaClip){
				if(sigma[s] > 1000)
					sigma[s] = 4096.0;
				else
					sigma[s] = 0.0;
			}
			
			pte.value = ocycleParam.stateTable[state].phaseTable[pllAddress >> 23];
			lo0 = pte.lo0;
			if(lo0 == 0)
				lo0 = -1;
			
			mult0 = -lo0 * frefGain * int(fref[s]);
			pllError0 = filter0.process(mult0);
			
			lo1 = pte.lo1;
			if(lo1 == 0)
				lo1 = -1;
			
			mult1 = -lo1 * int(sigma[s]);
			pllError1 = filter1.process(mult1);
			
			if(pllSelect)
				pllError = int(pllGain * pllError1);
			else
				pllError = int(pllGain * pllError0);
			
			pllFrequency += pllError;
			if(s & 1)
				pllAddress += pllFrequency;
			
			file.printf("%f ", fref[s]);
			file.printf("%d ", lo0);
			file.printf("%d ", mult0);

			file.printf("%f ", sigma[s]);
			file.printf("%d ", pte.gate);
			file.printf("%d ", lo1);
			file.printf("%d ", mult1);

			file.printf("%d ", pllError1);
			file.printf("%d ", pllError);
			file.printf("%d ", pllFrequency);
//			file.printf("%u ", pllAddress);
			file.printf("\n");
		}
	}

	return err;
}
