/*******************************************************************************
 *	Blr.h		TMS State Table Blr
 *			T.Barnaby,	BEAM Ltd,	2007-06-25
 *******************************************************************************
 */

#ifndef Blr_h
#define Blr_h	1

#include <BError.h>
#include <BFile.h>
#include <BNameValue.h>
#include <SigGen.h>
#include <TmsLib.h>

using namespace Tms;

typedef BNameValue<BString>	Param;

class ParamList : public BNameValueList<BString> {
public:
	BString		getValue(BString name);
	void		setValue(BString name, BString value);
};


class Blr {
public:
				Blr();
				~Blr();
	
	BError			init(ParamList& params);
	BError			run();

protected:
	ParamList		oparams;

	BString			ofileName;
	double			osampleRate;
	double			ofref;
	CycleParam		ocycleParam;
};

#endif
