/***************************************************************************
 *	TmsStateGui.h	TMS Cycle parameters State display
 *			T.Barnaby,	BEAM Ltd,	2007-11-13
 ***************************************************************************
 */
#ifndef	TmsStateGui_H
#define TmsStateGui_H	1

#include <BWidgets.h>
#include <BError.h>
#include <BString.h>
#include <TmsCycleParam.h>
#include <BGraph.h>
#include <qtabwidget.h>
#include <qspinbox.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qscrollbar.h>
#include <qpushbutton.h>

class TmsStateGui: public BVBox {
	Q_OBJECT
public:
	TmsStateGui(QWidget* p);
	~TmsStateGui();

	void	init();					///< Initialise
	void	setState(int num);

public slots:
	BError	view(Tms::CycleParamEdit& cycleParam, int reset);
	void	updateState();
	void	update();
	void	scroll();
	void	zoomIn();
	void	zoomOut();

signals:
	void	stateChanged(int num);

private:
	void	zoom(int in);

	QScrollBar*		oscrollBar;
	QPushButton*		ozoomIn;
	QPushButton*		ozoomOut;
	BGrid*			oinfoBox;
	QSpinBox*		ostate;
	QLineEdit*		ostateInfo;
	QLineEdit*		ostateField0;
	QLineEdit*		ostateField1;

	Tms::CycleParamEdit	ocycleParam;
	BArray<BGraph*>		ographs;
	unsigned int		opos;
	unsigned int 		orange;
	unsigned int		orangeMax;
};
#endif
