/*
* Title:	OptionsWin.cpp
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-14
*
* Contents:	Option Control and Dialogs.
*
* Mod Rec:
*/
#include <OptionsWin.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <Globals.h>


OptionsWin::OptionsWin(QWidget* parent, Control& c) : ocontrol(c) {
	QGridLayout*	g = new QGridLayout(this);
	QWidget*	b = new QWidget(this);
	QHBoxLayout*	h  = new QHBoxLayout(b);
	QPushButton*	ok = new QPushButton("Ok",b);
	QPushButton*	cancel = new QPushButton("Cancel",b);
	QSpacerItem*	spacer = new QSpacerItem(20,20,QSizePolicy::Expanding, QSizePolicy::Minimum );

	owidgetStack = new QStackedWidget(this);
	olistBox = new QListWidget(this);

	setSizeGripEnabled(false);

 	cancel->setAutoDefault(true);

	h->addItem(spacer);
	h->addWidget(ok);
	h->addWidget(cancel);
	
	g->addWidget(olistBox, 0, 0);
	g->addWidget(owidgetStack, 0, 1);
	g->addWidget(b, 1, 0);
	
	odataOptions = new DataOptions(this,ocontrol);
	
	owidgetStack->addWidget(odataOptions);
	owidgetStack->setCurrentIndex(0);
	
	olistBox->clear();
	olistBox->addItem("Capture Options");
#ifdef ZAP_QT3
	olistBox->setSelected(0,true);
	olistBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)7, 0, 0,olistBox->sizePolicy().hasHeightForWidth() ) );
#endif
	connect(cancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(ok,SIGNAL(clicked()),this,SLOT(accept()));
	connect(olistBox, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(selected()));
}
OptionsWin::~OptionsWin() {}

void OptionsWin::show() {
	odataOptions->set();
	QDialog::show();
}

void OptionsWin::accept() {
	odataOptions->save();
	QDialog::accept();
}

void OptionsWin::selected() {
        int     selected = olistBox->currentRow();
	
	owidgetStack->setCurrentIndex(selected);
}

DataOptions::DataOptions(QWidget* parent,Control& c) : ocontrol(c) {
	QWidget*	page;
	QGridLayout*	grid;
	QLabel*		defaultServerLabel;
	
	page = new QWidget(this);
	this->addTab(page,"Basic");
	
        grid = new QGridLayout(page);
        grid->setMargin(20);
        grid->setSpacing(20);

	defaultServerLabel = new QLabel("Default Server", page);
	defaultServerLabel->setText("Default Server");
	odefaultServer = new QLineEdit(page);
	
	grid->addWidget(defaultServerLabel,0,0);
	grid->addWidget(odefaultServer,0,1);
}

DataOptions::~DataOptions() {}

void DataOptions::set() {
	BString	s;
	
	s = gconfig.findValue("DefaultServer:");
	odefaultServer->setText(s.retStr());
}
void DataOptions::save() {
	gconfig.setValue("DefaultServer:",odefaultServer->text());
	gconfig.write();
}
