
h=admxrc_init;
admxrc_setclockrate(h,0,50);
admxrc_setclockrate(h,1,125);
pause(.1);
admxrc_config(h,'wrapper.bit');
pause(1);

switchtable=uint32(zeros(1,16));
switchtable(1)=uint32(hex2dec('E31EE00'));
switchtable(2)=uint32(hex2dec('EEE2E01'));
switchtable(3)=uint32(hex2dec('E3EEE00'));
switchtable(4)=uint32(hex2dec('4EEEF03'));
switchtable(5)=uint32(hex2dec('5EEEF03'));
switchtable(6)=uint32(hex2dec('6EEEF03'));
switchtable(7)=uint32(hex2dec('EEEEF03'));
switchtable64 = typecast(switchtable,'double'); 

% Set up Switch Table 
admxrc_write32(h,0,int32(3));
admxrc_write64_dma(h,hex2dec('200000'),switchtable64);

% Set up Phase Tables 
phasetable = zeros(1,16*512,'int8');
for k=1:7
  phasetable((k-1)*512+(11:15)) = int8(5*ones(1,5));
  phasetable((k-1)*512+(16:20)) = int8(4*ones(1,5));
  phasetable((k-1)*512+(31:40)) = int8(2*ones(1,10));
end

phasetable64 = typecast(phasetable,'double');

admxrc_write32(h,0,int32(2));
admxrc_write64_dma(h,hex2dec('200000'),phasetable64);


% Set up test data
s = textread('../../simulation/beam1-437000-8-sigma.txt');
dx = textread('../../simulation/beam1-437000-8-deltax.txt');
dy = textread('../../simulation/beam1-437000-8-deltay.txt');
ls = length(s);

us = typecast(int32(s/16),'uint32');
udx = typecast(int32(dx/16),'uint32');
udy = typecast(int32(dy/16),'uint32');

td = us + uint32(2^12)*udx + uint32(2^22)*udy;
td64 = typecast(td(1:284),'double');
admxrc_write32(h,hex2dec('18'),int32(8+3));
admxrc_write64_dma(h,hex2dec('200000'),td64);
admxrc_write32(h,hex2dec('18'),int32(0));

% active test data generation
admxrc_write32(h,hex2dec('808'),int32(0));
admxrc_write32(h,hex2dec('820'),int32((ls-1)/2));
admxrc_write32(h,hex2dec('818'),int32(2^25));


% Enable Interrupts
admxrc_write32(h,hex2dec('20'),int32(-1));

% Set Frequency
admxrc_write32(h,hex2dec('8A0'),int32(2300457));
% set phase delay
admxrc_write32(h,hex2dec('8B0'),int32(-232));
% set gain
admxrc_write32(h,hex2dec('8B8'),int32(500));


% Pulse Init
admxrc_write32(h,hex2dec('880'),int32(1));
admxrc_write32(h,hex2dec('880'),int32(0));

% Enable test 10MHz clock
admxrc_write32(h,hex2dec('810'),int32(256));

% Display Status Register
disp(['Status: ' dec2hex(admxrc_read32(h,hex2dec('880'),1))])

admxrc_write32(h,hex2dec('888'),int32(3));
disp(['Cycle: ' dec2hex(admxrc_read32(h,hex2dec('888'),1))])

% ARM Diagnostics
admxrc_write32(h,hex2dec('8D8'),int32(64));
admxrc_write32(h,hex2dec('8D0'),int32(1+8));
disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])

% CYCLE_START
disp('CYCLE_START')
admxrc_write32(h,hex2dec('8E0'),int32(2+32256));
disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])


pause(.1);
admxrc_write32(h,hex2dec('8E0'),int32(32256));

% Display Status Register
disp(['Status: ' dec2hex(admxrc_read32(h,hex2dec('880'),1))])
% Display Diagnostics Register
disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])




% CAL_START
%disp('CAL_START')
%admxrc_write32(h,hex2dec('8E0'),int32(8+32256));
%admxrc_write32(h,hex2dec('8E0'),int32(32256));

% Display Status Register
%disp(['Status: ' dec2hex(admxrc_read32(h,hex2dec('880'),1))])
% Display CTIME Register
%disp(['CTIME: ' dec2hex(admxrc_read32(h,hex2dec('890'),1))])
%disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])
%pause(.1);

% Display Diagnostics Register
%disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])

% CAL_STOP
%disp('CAL_STOP')
%admxrc_write32(h,hex2dec('8E0'),int32(16+32256));
%admxrc_write32(h,hex2dec('8E0'),int32(32256));

% Display Status Register
disp(['Status: ' dec2hex(admxrc_read32(h,hex2dec('880'),1))])
% Display CTIME Register
disp(['CTIME: ' dec2hex(admxrc_read32(h,hex2dec('890'),1))])
disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])
pause(.1);

% INJECTION
disp('INJECTION')
admxrc_write32(h,hex2dec('8E0'),int32(32+32256));
admxrc_write32(h,hex2dec('8E0'),int32(32256));

% Display Status Register
disp(['Status: ' dec2hex(admxrc_read32(h,hex2dec('880'),1))])
% Display CTIME Register
disp(['CTIME: ' dec2hex(admxrc_read32(h,hex2dec('890'),1))])
disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])

pause(.1);


% HCHANGE
disp('HCHANGE')
admxrc_write32(h,hex2dec('8E0'),int32(64+32256));
admxrc_write32(h,hex2dec('8E0'),int32(32256));

% Display Status Register
disp(['Status: ' dec2hex(admxrc_read32(h,hex2dec('880'),1))])
% Display CTIME Register
disp(['CTIME: ' dec2hex(admxrc_read32(h,hex2dec('890'),1))])
disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])

pause(.1);

% HCHANGE
disp('HCHANGE')
admxrc_write32(h,hex2dec('8E0'),int32(64+32256));
admxrc_write32(h,hex2dec('8E0'),int32(32256));


% Display Status Register
disp(['Status: ' dec2hex(admxrc_read32(h,hex2dec('880'),1))])
% Display CTIME Register
disp(['CTIME: ' dec2hex(admxrc_read32(h,hex2dec('890'),1))])
disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])
pause(.1);

% CYCLE_STOP
disp('CYCLE_STOP')
admxrc_write32(h,hex2dec('8E0'),int32(4+32256));
admxrc_write32(h,hex2dec('8E0'),int32(32256));

pause(.1);

% Display Status Register
disp(['Status: ' dec2hex(admxrc_read32(h,hex2dec('880'),1))])
% Display CTIME Register
disp(['CTIME: ' dec2hex(admxrc_read32(h,hex2dec('890'),1))])
disp(['Cycle: ' dec2hex(admxrc_read32(h,hex2dec('888'),1))])
disp(['Diagnostics: ' dec2hex(admxrc_read32(h,hex2dec('8D0'),1))])
% Read Diagnostics Table 
admxrc_write32(h,0,int32(4));
tmp=admxrc_read64_dma(h,hex2dec('200000'),8192);
diag = typecast(tmp,'uint32');

disp(['IRQ: ' dec2hex(admxrc_read32(h,hex2dec('28'),1))])


% Read Cycle Information Table 
admxrc_write32(h,0,int32(1));
tmp=admxrc_read64_dma(h,hex2dec('200000'),32);
cycle_info= typecast(tmp,'uint32');
dec2hex(cycle_info);

% Read Cycle Information Table 
admxrc_write32(h,0,int32(0));
tmp=admxrc_read64_dma(h,hex2dec('200000'),2048);
cycle_timing= typecast(tmp,'uint32');
cycle_timing_cycles = cycle_timing(1:2:end);
cycle_timing_addr = cycle_timing(2:2:end);

% Read Data
admxrc_write32(h,24,int32(8));
tmp=admxrc_read64_dma(h,hex2dec('200000'),2*1024*1024/8);
d1 = typecast(tmp,'int16');



admxrc_close(h);
