/*******************************************************************************
 *	FpgaAccess.c	Fpga access test program
 *			T.Barnaby,	BEAM Ltd,	2007-05-01
 *******************************************************************************
 */
#include <stdlib.h>
#include <memory.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/time.h>
#include <admxrc2.h>
#include <pthread.h>

#define	DEBUG	0

#if DEBUG
#define	dprintf(fmt, a...)       printf(fmt, ##a);
#else
#define	dprintf(fmt, a...)
#endif

char		driver[] = "/dev/admxrc0";
// char		fpgafile[] = "/usr/tms/fpga/tms-fpga.bit";
char		fpgafile[] = "itest.bit";

ADMXRC2_HANDLE		card;
ADMXRC2_STATUS		status;
ADMXRC2_DMADESC		dmaDesc;
ADMXRC2_CARD_INFO	ocardInfo;
ADMXRC2_SPACE_INFO	spInfo;
volatile uint*		fpga;

// Get current time in seconds
double getTime()
{
	struct timeval	tp;
	
	gettimeofday(&tp, NULL);
	return ((double) tp.tv_sec + (double) tp.tv_usec * 1e-6);
}

void hd8(void* data, int n){
	unsigned char* d = (unsigned char*)data;
	int	i;
	
	for(i = 0; i < n; i++){
		printf("%2.2x ", *d++);
		if((i & 0xF) == 0xF)
			printf("\n");
	}
	printf("\n");
}

void hd32(void* data, int n){
	unsigned int* d = (unsigned int*)data;
	int	i;
	
	for(i = 0; i < n; i++){
		printf("%8.8x ", *d++);
		if((i & 0x7) == 0x7)
			printf("\n");
	}
	printf("\n");
}

/* FPGA registers */
#define FPGA_IMASK	(0x0U)
#define FPGA_ISTAT	(0x4U)
#define FPGA_IARM	(0x8U)
#define FPGA_TEST	(0xcU)

void test1(){
	printf("Enable and Trigger an interrupt\n");

	fpga[FPGA_IMASK >> 2] = 0;

	fpga[FPGA_TEST >> 2] = 1;

	pause();
}

void* interruptLoop(void* arg){
	while(1){
		printf("WaitForInterrupt\n");
		ADMXRC2_WaitForInterrupt(card, 0, 0, 0);
		printf("Interrupt !!\n");
	}
}

int main(int argc, char *argv[])
{
	float		clock_freq = 33.0e6f;
	float		clock_freq2 = 33.0e6f;
	ADMXRC2_STATUS	status;
	pthread_t	ithread;
	
	status = ADMXRC2_OpenCard(0, &card);
	if(status != ADMXRC2_SUCCESS) {
		printf("Failed to open driver (%s) Status (%x)\n", driver, status);
		return 1;
	}

	if((status = ADMXRC2_GetCardInfo(card, &ocardInfo)) != ADMXRC2_SUCCESS){
		printf("Failed to get info: %s\n", ADMXRC2_GetStatusString(status));
		return 1;
	}


	if((status = ADMXRC2_GetSpaceInfo(card, 0, &spInfo)) != ADMXRC2_SUCCESS){
		printf("Failed to read info %s\n", ADMXRC2_GetStatusString(status));
		return 1;
	}
	fpga = (volatile uint*)spInfo.VirtualBase;

	
	// Set up Clocks
	status = ADMXRC2_SetClockRate(card, 0, clock_freq, 0);
	if (status != ADMXRC2_SUCCESS){
		printf("Failed to set LCLK to %.1fMHz\n", clock_freq / 1.0e6f);
		return 1;
	}

	status = ADMXRC2_SetClockRate(card, 1, clock_freq2, 0);
	if (status != ADMXRC2_SUCCESS){
		printf("Failed to set MCLK to %.1fMHz\n", clock_freq / 1.0e6f);
		return 1;
	}

        printf("Programming FPGA: %s\n", fpgafile);
        if((status = ADMXRC2_ConfigureFromFile(card, fpgafile)) != ADMXRC2_SUCCESS) {
                printf("Unable to load fpga: status(%x)\n", status);
                return 1;
        }

	// Set off interrupt thread
	pthread_create(&ithread, 0, interruptLoop, 0);
	sleep(1);

	test1();
	
	// Close the device
	ADMXRC2_CloseCard(card);

	return 0;
}
