/*******************************************************************************
 *	BTime.h	BTime functions
 *	T.Barnaby,	Beam Ltd,	2012-11-12
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 *
 * Implements a simple date/time class. Stores the date/time as a number of seconds
 *  since 1970-01-02T00:00:00. Has a range until 2106-02-07.
 *
 * Uses some sepcial values.
 *  0 - DateTime not set.
 */
#ifndef BTime_h
#define BTime_h

#include <BTypes.h>
#include <BError.h>
#include <BString.h>

class BTime {
public:
			BTime(BUInt32 t = 0);
	
	void		set(BUInt32 seconds);									///< Set the date and time
	void		set(BUInt year, BUInt month, BUInt day, BUInt hour = 0, BUInt minute = 0, BUInt second = 0);	///< Set the date and time
	void		setYearDay(BUInt year, BUInt yearDay, BUInt hour = 0, BUInt minute = 0, BUInt second = 0);	///< Set the date and time
	
	void		getDate(BUInt& year, BUInt& month, BUInt& day) const;		///< Retun the date information
	void		getTime(BUInt& hour, BUInt& minute, BUInt& second) const;	///< Return the time information
	BUInt32		getSeconds() const;						///< Return the number of seconds

	int		isSet() const{ return otime != 0; }			///< Check if set
	int		isLeapYear();						///< Returns if a leap year
	void		addSeconds(int seconds);				///< Add the given number of seconds.

	BString		getString(BString format = "isoT") const;		///< Gets the date/time in string format
	BError		setString(const BString dateTime);					///< Sets the date/time from string format
	
			// Operator functions
	int		operator==(const BTime& time) const { return (otime == time.otime); }
	int		operator!=(const BTime& time) const { return (otime != time.otime); }
	int		operator>(const BTime& time) const { return (otime > time.otime); }
	int		operator>=(const BTime& time) const { return (otime >= time.otime); }
	int		operator<(const BTime& time) const { return (otime < time.otime); }
	int		operator<=(const BTime& time) const { return (otime <= time.otime); }
	BTime		operator+(int seconds) const { return BTime(getSeconds() + seconds); }
	BTime&		operator+=(int seconds){ addSeconds(seconds); return *this; }

private:
	BUInt32		otime;		///< Time in seconds since 1970. range 1970-01-02 to 2106-02-07
};

#endif 
