/*******************************************************************************
 *	BSemaphore.h	Semaphore Classes
 *	T.Barnaby,	BEAM Ltd,	2012-11-17
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BSemaphore_h
#define BSemaphore_h	1

#include <BTypes.h>
#include <BMutex.h>
#include <semaphore.h>

/// Semaphore class
class BSemaphore {
public:
				BSemaphore();
				BSemaphore(const BSemaphore& semaphore);
				~BSemaphore();
	
	Bool			wait(BTimeout timeoutUs = BTimeoutForever);		///< Wait for the semaphore
	void			set();							///< Set the semaphore

	int			getValue() const;
	BSemaphore&		operator=(const BSemaphore& semaphore);

private:
	sem_t			osema;
};

class BSemaphoreCount {
public:
				BSemaphoreCount();
				BSemaphoreCount(const BSemaphoreCount& semaphore);
				~BSemaphoreCount();

	void			setValue(BUInt v);	
	void			add(int v = 1);						///< Set the semaphore
	Bool			wait(BUInt v = 1, BTimeout timeoutUs = BTimeoutForever);	///< Wait for the semaphore
	Bool			take(BUInt v = 1, BTimeout timeoutUs = BTimeoutForever);	///< Take for the semaphore

	BUInt			value();

	BSemaphoreCount&	operator=(const BSemaphoreCount& semaphore);

private:
	BMutex			olock;
	BSemaphore		osema;
	volatile BUInt		ovalue;
};
#endif
