/*******************************************************************************
 *	BMysql.cpp	BDS Database Access Object
 *			T.Barnaby,	BEAM Ltd,	2008-05-20
 *******************************************************************************
 */

#include <stdlib.h>
#include <string.h>
#include <BMysql.h>

#ifdef ZAP
static BString sqlString(BString s){
	BString	r;
	int	i;
	
	for(i = 0; i < s.len(); i++){
		if(s[i] == '"'){
			r = r + "\\\"";
		}
		else {
			r = r + s[i];
		}
	}
	return r;
}
#endif

BMysql::BMysql(){
	oopened = 0;
	odebug = 0;
}

BMysql::~BMysql(){
	if(oopened)
		mysql_close(&odb);
	oopened = 0;
}

MYSQL& BMysql::db(){
	return odb;
}

void BMysql::setDebug(int debug){
	odebug = debug;
}

BError BMysql::open(BString hostName, BString dataBase, BString userName, BString password){
	BError	err;
	my_bool	flag = 1;

	if(!oopened){
		olock.lock();
		mysql_init(&odb);
		if(!mysql_real_connect(&odb, hostName, userName, password, dataBase, 0, 0, 0)){
			err.set(ErrorMisc, BString("Error: Unable to open database connection to: ") + hostName);
		}
		
		if(!err){
			// Enable automatic reconnection
			mysql_options(&odb, MYSQL_OPT_RECONNECT, &flag);
		}
		oopened = 1;	
		olock.unlock();
	}
	return err;
}

void BMysql::close(){
	if(oopened){
		mysql_close(&odb);
		oopened = 0;
	}
}

BError BMysql::get(BString table, BString where, BDictString& fields){
	BError			err;
	BList<BDictString>	res;

	fields.clear();
	if(err = query(BString("select * from `") + table + "` where " + where, res))
		return err;
	
	if(res.number()){
		fields = res[0];
	}
	else {
		err.set(ErrorMisc, "No records");
	}

	return err;
}

BError BMysql::insert(BString table, BDictString fields, BUInt32* id){
	BError			err;
	BString			cmd;
	BString			args;
	BDictString::iterator	i;
	BList<BDictString>	res;
	
	cmd = BString("insert into `") + table + "` set ";
	for(fields.start(i); !fields.isEnd(i); fields.next(i)){
		if(args.len())
			args += ",";
		args = args + "`" + fields.key(i) + "` = '" + escapeString(fields[i]) + "'";
	}
	
	err = query(cmd + args, res);
	
	if(id){
		if(err)
			*id = 0;
		else
			*id = mysql_insert_id(&odb);
	}

	return err;
}

BError BMysql::update(BString table, BUInt32 id, BDictString fields){
	BError			err;
	BString			cmd;
	BString			args;
	BDictString::iterator	i;
	BList<BDictString>	res;
	
	cmd = BString("update `") + table + "` set ";
	for(fields.start(i); !fields.isEnd(i); fields.next(i)){
		if(args.len())
			args += ",";
		args = args + "`" + fields.key(i) + "` = '" + escapeString(fields[i]) + "'";
	}
	
	err = query(cmd + args + " where `id` = '" + id + "'", res);

	return err;
}

BError BMysql::del(BString table, BUInt32 id){
	BError			err;
	BString			cmd;
	BList<BDictString>	res;
	
	cmd = BString("delete from `") + table + "` where `id` = '" + id + "'";
	err = query(cmd, res);
	
	return err;
}

BError BMysql::query(BString cmd, BList<BDictString>& result){
	BError		err;
	MYSQL_RES*	res;
	MYSQL_ROW	row;
	MYSQL_FIELD*	fields;
	int		numColumns;
	int		c;
	
	if(odebug)
		std::cout << "BMysql::query: " << cmd << "\n";
	
	olock.lock();
	result.clear();
	
	if(mysql_query(&odb, cmd)){
		olock.unlock();
		return err.set(ErrorMisc, BString("Error: SQL query error: ") + cmd + ": " + mysql_error(&odb));
	}

	if(res = mysql_store_result(&odb)){
		numColumns = mysql_num_fields(res);
		fields = mysql_fetch_fields(res);
	
		while(row = mysql_fetch_row(res)){
			BDictString	dlist;
			for(c = 0; c < numColumns; c++){
				dlist[BString(fields[c].name)] = row[c];
			}
			result.append(dlist);
		}

		mysql_free_result(res);
	}
	olock.unlock();
	
	return err;
}

BError BMysql::flush(){
	BList<BDictString>	res;

	return query("flush tables", res);
}

BString BMysql::escapeString(BString str){
	char	s[str.len() * 2 + 1];

	mysql_real_escape_string(&odb, s, str, str.len());
	
	return s;
}
