/*******************************************************************************
 *	BDict.h	BEAM Dictionary class
 *			T.Barnaby,	BEAM Ltd,	2008-05-21
 *******************************************************************************
 */
#include <BDict.h>

void toBString(const BDictString& v, BString& s){
	BIter	i;
	
	for(v.start(i); !v.isEnd(i); v.next(i)){
		if(s.len())
			s += ",";
		s = s + v.key(i) + ":" + v[i];
	}
}

void fromBString(const BString& str, BDictString& v){
	BString		sp = str;
	BString		s;
	
	while((s = sp.pullToken(",").removeSeparators(" \t")) != ""){
		v[s.pullToken(":")] = s;
	}
}

BString bdictStringToString(const BDictString& dict){
	BString	s;
	
	toBString(dict, s);
	return s;
}
