/*******************************************************************************
 *	BDebug.cpp	Debug routines
 *			T.Barnaby,	BEAM Ltd,	2009-01-05
 *******************************************************************************
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdarg.h>
#include <fcntl.h>
#include <execinfo.h>
#include <ctype.h>
#include <BDebug.h>

int		bdebug;

void hd8(void* data, unsigned int n){
	unsigned char*	d = (unsigned char*)data;
	unsigned		i;
	
	for(i = 0; i < n; i++){
		printf("%2.2x ", *d++);
		if((i & 0xF) == 0xF)
			printf("\n");
	}
	printf("\n");
}

void hd8a(void* data, unsigned int n){
	unsigned char*	d = (unsigned char*)data;
	unsigned	i;
	char		ascii[17];
	
	memset(ascii, ' ', 16);
	ascii[16] = '\0';
	
	for(i = 0; i < n; i++){
		if(isprint(*d))
			ascii[i % 16] = *d;
		else
			ascii[i % 16] = '.';

		printf("%2.2x ", *d++);
		if((i & 0xF) == 0xF){
			printf("  %s\n", ascii);
			memset(ascii, ' ', 16);
		}
	}
	printf("\n");
}

void hda8(void* data, unsigned int n){
	unsigned char*	d = (unsigned char*)data;
	unsigned int	i;
	
	for(i = 0; i < n; i++){
		if((i % 16) == 0)
			printf("%4.4x: ", i);
		printf("%2.2x ", *d++);
		if((i & 0xF) == 0xF)
			printf("\n");
	}
	printf("\n");
}

void hd32(void* data, unsigned int n){
	unsigned int*	d = (unsigned int*)data;
	unsigned		i;
	
	for(i = 0; i < n; i++){
		printf("%8.8x ", *d++);
		if((i & 0x7) == 0x7)
			printf("\n");
	}
	printf("\n");
}

void hda32(void* data, unsigned int n){
	unsigned int*	d = (unsigned int*)data;
	unsigned int	i;
	
	for(i = 0; i < n; i++){
		if((i % 8) == 0)
			printf("%4.4x: ", i);
		printf("%8.8x ", *d++);
		if((i & 0x7) == 0x7)
			printf("\n");
	}
	printf("\n");
}

// Get current time in seconds
double getTime()
{
	struct timeval	tp;
	
	gettimeofday(&tp, NULL);
	return ((double) tp.tv_sec + (double) tp.tv_usec * 1e-6);
}

void setDebug(int d){
	bdebug = d;
}

void tprintf(int log, const char* fmt, ...){
	va_list		args;
	char		tbuf[64];
	char		buf[4096];
	struct timeval	tv;
	
	va_start(args, fmt);
	gettimeofday(&tv, 0);

#if DEBUG_WITH_DATE
	strftime(tbuf, sizeof(tbuf), "%b %d %H:%M:%S", localtime(&tv.tv_sec));
#else
	strftime(tbuf, sizeof(tbuf), "%H:%M:%S", localtime(&tv.tv_sec));
#endif

	sprintf(buf, "%s.%3.3ld: Thread(%d) %s", tbuf, tv.tv_usec/1000, gettid(), fmt);

	vfprintf(stderr, buf, args);
	if(log){
		va_start(args, fmt);
		vsyslog(LOG_DEBUG, buf, args);
	}
}

#include <errno.h>
#include <linux/unistd.h>

pid_t gettid(){
	return syscall(__NR_gettid);
}


#define	BTRACE_SIZE	100

const unsigned int	STRBUF_SIZE	= (64 * 1024);

BDebugBacktrace::BDebugBacktrace(){
}

BDebugBacktrace::~BDebugBacktrace(){
}

void BDebugBacktrace::dumpBacktrace(char* strBuf, int strBufLen, char* comment){
	void*	bt[BTRACE_SIZE];
	int	btn;
	char**	p;
	int	n;

	if(comment)
		strcpy(strBuf, comment);
	else
		strcpy(strBuf, "");
	
	btn = backtrace(bt, BTRACE_SIZE);
	p = backtrace_symbols(bt, btn);
	
	for(n = 0 ; n < btn; n++){
		strcat(strBuf, p[n]);
		strcat(strBuf, "\n");
	}
}

void BDebugBacktrace::dumpBacktraceStdout(char* comment){
	char	strBuf[STRBUF_SIZE];

	dumpBacktrace(strBuf, sizeof(strBuf), comment);
	
	write(1, strBuf, strlen(strBuf));
}

int BDebugBacktrace::dumpBacktraceFile(char* fileName, char* comment){
	int	fd;
	char	strBuf[STRBUF_SIZE];

	if((fd = open(fileName, O_CREAT | O_RDWR | O_APPEND, 0666)) < 0){
		return fd;
	}

	dumpBacktrace(strBuf, sizeof(strBuf), comment);
	
	write(fd, strBuf, strlen(strBuf));
	close(fd);

	return 0;
}

void BDebugBacktrace::dumpBacktraceSyslog(char* comment){
	char	strBuf[STRBUF_SIZE];

	dumpBacktrace(strBuf, sizeof(strBuf), comment);
	
	syslog(LOG_ERR, "%s", strBuf);
}
