/*******************************************************************************
 *	BDate.h	TimeStamp classes
 *			T.Barnaby,	BEAM Ltd,	2005-10-20
 *******************************************************************************
 */
#include <BDate.h>
#include <sys/time.h>

static int mon_yday[2][13] = {
	/* Normal years.  */
	{ 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365 },
	/* Leap years.  */
	{ 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366 }
};

BDate::BDate(int year, int month, int day){
	set(year, month, day);
}

BDate::BDate(BString str){
	if(str == "")
		clear();
	else
		setString(str);
}

BDate::~BDate(){
}

void BDate::clear(){
	oyear = 0;
	oyday = 0;	
}

void BDate::setFirst(){
	setYDay(1, 0);
}

void BDate::setLast(){
	setYDay(9999, 0);
}

void BDate::setYDay(int year, int yday){
	oyear = year;
	oyday = yday;
}

void BDate::set(time_t time){
	struct tm	tm;
	
	gmtime_r(&time, &tm);
	
	oyear = 1900 + tm.tm_year;
	oyday = tm.tm_yday;
}

void BDate::set(int year, int month, int day){
	oyear = year;
	oyday = mon_yday[isLeap(year)][month-1] + day - 1;
}

void BDate::setNow(){
	struct timeval	tv;
	struct tm	tm;
	
	gettimeofday(&tv, 0);
	gmtime_r(&tv.tv_sec, &tm);
	
	oyear = 1900 + tm.tm_year;
	oyday = tm.tm_yday;
}

int BDate::year(){
	return oyear;
}

int BDate::month(){
	int		mon = 0;
	
	for(mon = 11; oyday < mon_yday[isLeap(oyear)][mon]; --mon);
	return mon + 1;
}

int BDate::day(){
	int		mon = 0;
	int		day = 0;
	
	for(mon = 11; oyday < mon_yday[isLeap(oyear)][mon]; --mon);
	day = oyday - mon_yday[isLeap(oyear)][mon];
	
	return day + 1;
}

int BDate::yday(){
	return oyday;
}

BString BDate::getString(){
	BString		s;
	int		mon = 0;
	int		day = 0;
	
	for(mon = 11; oyday < mon_yday[isLeap(oyear)][mon]; --mon);
	day = oyday - mon_yday[isLeap(oyear)][mon];

	s.printf("%04d-%02d-%02d", oyear, mon + 1, day + 1);
	return s;
}


BString	BDate::getStringFormatted(BString format){
	struct tm	tm;
	int		mon = 0;
	int		day = 0;
	char		buf[64];
	
	for(mon = 11; oyday < mon_yday[isLeap(oyear)][mon]; --mon);
	day = oyday - mon_yday[isLeap(oyear)][mon];
	
	tm.tm_sec = 0;
	tm.tm_min = 0;
	tm.tm_hour = 0;
	tm.tm_mday = day + 1;
	tm.tm_mon = mon;
	tm.tm_year = oyear - 1900;
	tm.tm_wday = 0;
	tm.tm_yday = oyday;
	tm.tm_isdst = 0;
	strftime(buf, sizeof(buf), format, &tm);
	
	return buf;
}

BError BDate::setString(BString date){
	BError		err;
	int		y = 0;
	int		mon = 0;
	int		day = 0;
	int		h = 0;
	int		m = 0;
	int		s = 0;
	int		ms = 0;
	int		n;

	clear();
	if(date == "first")
		setFirst();
	else if(date == "last")
		setLast();
	else if(date == "now")
		setNow();
	else {
		n = sscanf(date, "%04u-%02u-%02u%*[ T]%02u:%02u:%02u.%06u", &y, &mon, &day, &h, &m, &s, &ms);
		if((n != 3) && (n != 6) && (n != 7)){
			if(date.find('/') == 4){
				n = sscanf(date, "%04u/%02u/%02u%*[ T]%02u:%02u:%02u.%06u", &y, &mon, &day, &h, &m, &s, &ms);
				if((n != 3) && (n != 6) && (n != 7)){
					err.set(ErrorMisc, BString("Time format error: ") + date);
				}
			}
			else if(date.find('/') == 2){
				n = sscanf(date, "%02u/%02u/%04u%*[ T]%02u:%02u:%02u.%06u", &day, &mon, &y, &h, &m, &s, &ms);
				if((n != 3) && (n != 6) && (n != 7)){
					err.set(ErrorMisc, BString("Time format error: ") + date);
				}
			}
			else{
				err.set(ErrorMisc, BString("Time format error: ") + date);
			}
		}

		if(!err){
			oyear = y;
			oyday = mon_yday[isLeap(oyear)][mon-1] + day - 1;
		}
	}
	return err;
}

void BDate::getDate(int& year, int& mon, int& day){
	year = oyear;
	for(mon = 11; oyday < mon_yday[isLeap(oyear)][mon]; --mon);
	day = oyday - mon_yday[isLeap(oyear)][mon];
}

int BDate::compare(const BDate& timeStamp) const {
	if(oyear > timeStamp.oyear)
		return 1;
	else if(oyear < timeStamp.oyear)
		return -1;

	else if(oyday > timeStamp.oyday)
		return 1;
	else if(oyday < timeStamp.oyday)
		return -1;

	else
		return 0;
}

int BDate::isLeap(int year){
	return ((year) % 4 == 0 && ((year) % 100 != 0 || (year) % 400 == 0));
}

int BDate::daysInMonth(int year, int month){
	if((month > 0) && (month <= 12))
		return mon_yday[isLeap(year)][month] - mon_yday[isLeap(year)][month - 1];
	else
		return 0;
}

void toBString(BDate& v, BString& s){
	s = v.getString();
}

void fromBString(BString& s, BDate& v){
	v.setString(s);
}
